/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.TickerUtil;
import com.tom.storagemod.block.IPaintable;
import com.tom.storagemod.proxy.ClientProxy;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import com.tom.storagemod.tile.TileEntityPainted;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;

public class BlockInventoryProxy
extends BaseEntityBlock
implements IPaintable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<DirectionWithNull> FILTER_FACING = EnumProperty.m_61587_((String)"filter_facing", DirectionWithNull.class);

    public BlockInventoryProxy() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(3.0f));
        this.setRegistryName("ts.inventory_proxy");
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_(FILTER_FACING, (Comparable)((Object)DirectionWithNull.NULL)));
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.toms_storage.paintable"));
        ClientProxy.tooltip("inventory_proxy", tooltip);
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("tooltip.toms_storage.inventory_proxy.key", new Object[]{"ignoreSize", new TranslatableComponent("tooltip.toms_storage.inventory_proxy.ignoreSize")}));
            tooltip.add((Component)new TranslatableComponent("tooltip.toms_storage.inventory_proxy.value", new Object[]{"maxCount", new TranslatableComponent("tooltip.toms_storage.inventory_proxy.maxCount.arg"), new TranslatableComponent("tooltip.toms_storage.inventory_proxy.maxCount.desc")}));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityInventoryProxy(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILTER_FACING});
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    @Override
    public boolean paint(Level world, BlockPos pos, BlockState to) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof TileEntityPainted) {
            return ((TileEntityPainted)te).setPaintedBlockState(to);
        }
        return false;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List stacks = super.m_7381_(state, builder);
        if (state.m_61143_(FILTER_FACING) != DirectionWithNull.NULL) {
            stacks.add(new ItemStack((ItemLike)Items.f_42415_));
        }
        return stacks;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (state.m_61143_(FILTER_FACING) != DirectionWithNull.NULL && te instanceof TileEntityInventoryProxy) {
            return ((TileEntityInventoryProxy)te).getComparatorOutput();
        }
        return AbstractContainerMenu.m_38918_((BlockEntity)te);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42415_ && state.m_61143_((Property)FACING) != hit.m_82434_()) {
            if (state.m_61143_(FILTER_FACING) == DirectionWithNull.NULL && !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            world.m_46597_(pos, (BlockState)state.m_61124_(FILTER_FACING, (Comparable)((Object)DirectionWithNull.of(hit.m_82434_()))));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum DirectionWithNull implements StringRepresentable
    {
        NULL("notset"),
        DOWN(Direction.DOWN),
        UP(Direction.UP),
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST);

        private final String name;
        private final Direction dir;
        private static final Map<Direction, DirectionWithNull> dir2dirwn;

        private DirectionWithNull(Direction dir) {
            this.name = dir.m_7912_();
            this.dir = dir;
        }

        public static DirectionWithNull of(Direction side) {
            return dir2dirwn.get(side);
        }

        private DirectionWithNull(String name) {
            this.name = name;
            this.dir = null;
        }

        public String m_7912_() {
            return this.name;
        }

        public Direction getDir() {
            return this.dir;
        }

        static {
            dir2dirwn = new HashMap<Direction, DirectionWithNull>();
            for (DirectionWithNull dwn : DirectionWithNull.values()) {
                if (dwn.dir == null) continue;
                dir2dirwn.put(dwn.dir, dwn);
            }
        }
    }
}

