/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.GuiStorageTerminal;
import com.tom.storagemod.gui.GuiStorageTerminalBase;
import com.tom.storagemod.network.IDataReceiver;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.tile.TileEntityStorageTerminal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class ContainerStorageTerminal
extends RecipeBookMenu<CraftingContainer>
implements IDataReceiver {
    private static final int DIVISION_BASE = 1000;
    private static final char[] ENCODED_POSTFIXES = "KMGTPE".toCharArray();
    public static final Format format;
    protected TileEntityStorageTerminal te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = Lists.newArrayList();
    public List<StoredItemStack> itemListClient = Lists.newArrayList();
    public List<StoredItemStack> itemListClientSorted = Lists.newArrayList();
    private Map<StoredItemStack, Long> itemsCount = new HashMap<StoredItemStack, Long>();
    private int lines;
    protected Inventory pinv;
    public Runnable onPacket;
    public int terminalData;
    public String search;

    public ContainerStorageTerminal(int id, Inventory inv, TileEntityStorageTerminal te) {
        this(StorageMod.storageTerminal, id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public ContainerStorageTerminal(MenuType<?> type, int id, Inventory inv, TileEntityStorageTerminal te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots();
    }

    public ContainerStorageTerminal(MenuType<?> type, int id, Inventory inv) {
        this(type, id, inv, null);
    }

    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public ContainerStorageTerminal(int id, Inventory inv) {
        this(StorageMod.storageTerminal, id, inv);
        this.addPlayerSlots(inv, 8, 120);
    }

    protected void addPlayerSlots(Inventory playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.f_38839_.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public final void addStorageSlots(int lines, int x, int y) {
        this.storageSlotList.clear();
        this.lines = lines;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotStorage(this.te, i * 9 + j, x + j * 18, y + i * 18));
            }
        }
        this.scrollTo(0.0f);
    }

    protected final void addSlotToContainer(SlotStorage slotStorage) {
        this.storageSlotList.add(slotStorage);
    }

    public static String formatNumber(long number) {
        String slimResult;
        int width = 4;
        assert (number >= 0L);
        String numberString = Long.toString(number);
        int numberSize = numberString.length();
        if (numberSize <= width) {
            return numberString;
        }
        long base = number;
        double last = base * 1000L;
        int exponent = -1;
        String postFix = "";
        while (numberSize > width) {
            last = base;
            numberSize = Long.toString(base /= 1000L).length() + 1;
            postFix = String.valueOf(ENCODED_POSTFIXES[++exponent]);
        }
        String withPrecision = format.format(last / 1000.0) + postFix;
        String withoutPrecision = Long.toString(base) + postFix;
        String string = slimResult = withPrecision.length() <= width ? withPrecision : withoutPrecision;
        assert (slimResult.length() <= width);
        return slimResult;
    }

    public boolean m_6875_(Player playerIn) {
        return this.te == null || this.te.canInteractWith(playerIn);
    }

    public final void scrollTo(float p_148329_1_) {
        int i = (this.itemListClientSorted.size() + 9 - 1) / 9 - this.lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < this.lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemListClientSorted.size()) {
                    this.setSlotContents(l + k * 9, this.itemListClientSorted.get(i1));
                    continue;
                }
                this.setSlotContents(l + k * 9, null);
            }
        }
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public int drawSlots(PoseStack st, GuiStorageTerminalBase gui, int mouseX, int mouseY) {
        int i;
        for (i = 0; i < this.storageSlotList.size(); ++i) {
            this.storageSlotList.get(i).drawSlot(st, gui, mouseX, mouseY);
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        st.m_85836_();
        st.m_85837_(0.0, 0.0, 100.0);
        for (i = 0; i < this.storageSlotList.size(); ++i) {
            if (!this.storageSlotList.get(i).drawTooltip(st, gui, mouseX, mouseY)) continue;
            st.m_85849_();
            return i;
        }
        st.m_85849_();
        return -1;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void m_38946_() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks();
        if (!this.itemsCount.equals(itemsCount)) {
            ListTag list = new ListTag();
            CompoundTag mainTag = new CompoundTag();
            this.itemList.clear();
            for (Map.Entry<StoredItemStack, Long> e : itemsCount.entrySet()) {
                StoredItemStack storedS = e.getKey();
                CompoundTag tag = new CompoundTag();
                storedS.writeToNBT(tag, e.getValue());
                list.add((Object)tag);
                this.itemList.add(new StoredItemStack(e.getKey().getStack(), e.getValue()));
            }
            mainTag.m_128365_("l", (Tag)list);
            mainTag.m_128405_("p", this.te.getSorting());
            mainTag.m_128359_("s", this.te.getLastSearch());
            NetworkHandler.sendTo((ServerPlayer)this.pinv.f_35978_, mainTag);
            this.itemsCount = new HashMap<StoredItemStack, Long>(itemsCount);
        }
        super.m_38946_();
    }

    public final void receiveClientNBTPacket(CompoundTag message) {
        ListTag list = message.m_128437_("l", 10);
        this.itemList.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            this.itemList.add(StoredItemStack.readFromNBT(tag));
        }
        this.itemListClient = new ArrayList<StoredItemStack>(this.itemList);
        this.pinv.m_6596_();
        this.terminalData = message.m_128451_("p");
        this.search = message.m_128461_("s");
        if (this.onPacket != null) {
            this.onPacket.run();
        }
    }

    public final ItemStack m_7648_(Player playerIn, int index) {
        if (this.f_38839_.size() > index) {
            if (index > this.playerSlotsStart && this.te != null) {
                if (this.f_38839_.get(index) != null && ((Slot)this.f_38839_.get(index)).m_6657_()) {
                    Slot slot = (Slot)this.f_38839_.get(index);
                    ItemStack slotStack = slot.m_7993_();
                    StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.m_41613_()));
                    ItemStack itemstack = c != null ? c.getActualStack() : ItemStack.f_41583_;
                    slot.m_5852_(itemstack);
                    if (!playerIn.f_19853_.f_46443_) {
                        this.m_38946_();
                    }
                }
            } else {
                return this.shiftClickItems(playerIn, index);
            }
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack shiftClickItems(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack matchTo, boolean checkNBT) {
        if (stack.m_41619_() && matchTo.m_41619_()) {
            return false;
        }
        if (!stack.m_41619_() && !matchTo.m_41619_() && stack.m_41720_() == matchTo.m_41720_()) {
            boolean equals = true;
            if (checkNBT) {
                equals = equals && ItemStack.m_41658_((ItemStack)stack, (ItemStack)matchTo);
            }
            return equals;
        }
        return false;
    }

    public void m_5816_(StackedContents itemHelperIn) {
    }

    public void m_6650_() {
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return false;
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return 0;
    }

    public int m_6656_() {
        return 0;
    }

    public int m_6653_() {
        return 0;
    }

    public void sendMessage(CompoundTag compound) {
        NetworkHandler.sendDataToServer(compound);
    }

    @Override
    public void receive(CompoundTag message) {
        if (this.pinv.f_35978_.m_5833_()) {
            return;
        }
        if (message.m_128441_("s")) {
            this.te.setLastSearch(message.m_128461_("s"));
        }
        if (message.m_128441_("a")) {
            ServerPlayer player = (ServerPlayer)this.pinv.f_35978_;
            player.m_9243_();
            CompoundTag d = message.m_128469_("a");
            ItemStack clicked = ItemStack.m_41712_((CompoundTag)d.m_128469_("s"));
            SlotAction act = SlotAction.VALUES[Math.abs(d.m_128451_("a")) % SlotAction.VALUES.length];
            if (act == SlotAction.SPACE_CLICK) {
                for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                    this.m_7648_((Player)player, i);
                }
            } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
                ItemStack stack = this.m_142621_();
                if (!stack.m_41619_()) {
                    StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack));
                    ItemStack itemstack = rem == null ? ItemStack.f_41583_ : rem.getActualStack();
                    this.m_142503_(itemstack);
                } else {
                    if (clicked.m_41619_()) {
                        return;
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), clicked.m_41741_());
                    if (pulled != null) {
                        this.m_142503_(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.PULL_ONE) {
                ItemStack stack = this.m_142621_();
                if (clicked.m_41619_()) {
                    return;
                }
                if (d.m_128471_("m")) {
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), 1L);
                    if (pulled != null) {
                        ItemStack itemstack = pulled.getActualStack();
                        this.m_38903_(itemstack, this.playerSlotsStart + 1, this.f_38839_.size(), true);
                        if (itemstack.m_41613_() > 0) {
                            this.te.pushOrDrop(itemstack);
                        }
                        player.m_150109_().m_6596_();
                    }
                } else if (!stack.m_41619_()) {
                    StoredItemStack pulled;
                    if (ContainerStorageTerminal.areItemStacksEqual(stack, clicked, true) && stack.m_41613_() + 1 <= stack.m_41741_() && (pulled = this.te.pullStack(new StoredItemStack(clicked), 1L)) != null) {
                        stack.m_41769_(1);
                    }
                } else {
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), 1L);
                    if (pulled != null) {
                        this.m_142503_(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_HALF) {
                ItemStack stack = this.m_142621_();
                if (!stack.m_41619_()) {
                    ItemStack stack1 = stack.m_41620_(Math.max(Math.min(stack.m_41613_(), stack.m_41741_()) / 2, 1));
                    ItemStack itemstack = this.te.pushStack(stack1);
                    stack.m_41769_(!itemstack.m_41619_() ? itemstack.m_41613_() : 0);
                    this.m_142503_(stack);
                } else {
                    if (clicked.m_41619_()) {
                        return;
                    }
                    long maxCount = 64L;
                    StoredItemStack clickedSt = new StoredItemStack(clicked);
                    for (int i = 0; i < this.itemList.size(); ++i) {
                        StoredItemStack e = this.itemList.get(i);
                        if (!e.equals((Object)clickedSt)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), Math.max(Math.min(maxCount, (long)clicked.m_41741_()) / 2L, 1L));
                    if (pulled != null) {
                        this.m_142503_(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_QUARTER) {
                ItemStack stack = this.m_142621_();
                if (!stack.m_41619_()) {
                    ItemStack stack1 = stack.m_41620_(Math.max(Math.min(stack.m_41613_(), stack.m_41741_()) / 4, 1));
                    ItemStack itemstack = this.te.pushStack(stack1);
                    stack.m_41769_(!itemstack.m_41619_() ? itemstack.m_41613_() : 0);
                    this.m_142503_(stack);
                } else {
                    if (clicked.m_41619_()) {
                        return;
                    }
                    long maxCount = 64L;
                    StoredItemStack clickedSt = new StoredItemStack(clicked);
                    for (int i = 0; i < this.itemList.size(); ++i) {
                        StoredItemStack e = this.itemList.get(i);
                        if (!e.equals((Object)clickedSt)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), Math.max(Math.min(maxCount, (long)clicked.m_41741_()) / 4L, 1L));
                    if (pulled != null) {
                        this.m_142503_(pulled.getActualStack());
                    }
                }
            } else {
                if (clicked.m_41619_()) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), clicked.m_41741_());
                if (pulled != null) {
                    ItemStack itemstack = pulled.getActualStack();
                    this.m_38903_(itemstack, this.playerSlotsStart + 1, this.f_38839_.size(), true);
                    if (itemstack.m_41613_() > 0) {
                        this.te.pushOrDrop(itemstack);
                    }
                    player.m_150109_().m_6596_();
                }
            }
        }
        if (message.m_128441_("c")) {
            CompoundTag d = message.m_128469_("c");
            this.te.setSorting(d.m_128451_("d"));
        }
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int p_150635_) {
        return false;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format_ = new DecimalFormat(".#;0.#");
        format_.setDecimalFormatSymbols(symbols);
        format_.setRoundingMode(RoundingMode.DOWN);
        format = format_;
    }

    public static class SlotStorage {
        public int xDisplayPosition;
        public int yDisplayPosition;
        private final int slotIndex;
        public final TileEntityStorageTerminal inventory;
        public StoredItemStack stack;

        public SlotStorage(TileEntityStorageTerminal inventory, int slotIndex, int xPosition, int yPosition) {
            this.xDisplayPosition = xPosition;
            this.yDisplayPosition = yPosition;
            this.slotIndex = slotIndex;
            this.inventory = inventory;
        }

        public ItemStack pullFromSlot(long max) {
            if (this.stack == null || max < 1L || this.inventory == null) {
                return ItemStack.f_41583_;
            }
            StoredItemStack r = this.inventory.pullStack(this.stack, max);
            if (r != null) {
                return r.getActualStack();
            }
            return ItemStack.f_41583_;
        }

        public ItemStack pushStack(ItemStack pushStack) {
            if (this.inventory == null) {
                return pushStack;
            }
            StoredItemStack r = this.inventory.pushStack(new StoredItemStack(pushStack, pushStack.m_41613_()));
            if (r != null) {
                return r.getActualStack();
            }
            return ItemStack.f_41583_;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void drawSlot(PoseStack st, GuiStorageTerminalBase gui, int mouseX, int mouseY) {
            if (mouseX >= gui.getGuiLeft() + this.xDisplayPosition - 1 && mouseY >= gui.getGuiTop() + this.yDisplayPosition - 1 && mouseX < gui.getGuiLeft() + this.xDisplayPosition + 17 && mouseY < gui.getGuiTop() + this.yDisplayPosition + 17) {
                int l = gui.getGuiLeft() + this.xDisplayPosition;
                int t = gui.getGuiTop() + this.yDisplayPosition;
                GuiStorageTerminal.m_93172_((PoseStack)st, (int)l, (int)t, (int)(l + 16), (int)(t + 16), (int)-2130706433);
            }
            if (this.stack != null) {
                st.m_85836_();
                gui.renderItemInGui(st, this.stack.getStack().m_41777_().m_41620_(1), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition, 0, 0, false, 0xFFFFFF, false, new String[0]);
                Font r = gui.getFont();
                this.drawStackSize(st, r, this.stack.getQuantity(), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition);
                st.m_85849_();
            }
        }

        public boolean drawTooltip(PoseStack st, GuiStorageTerminalBase gui, int mouseX, int mouseY) {
            if (this.stack != null) {
                if (this.stack.getQuantity() > 9999L) {
                    gui.renderItemInGui(st, this.stack.getStack(), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition, mouseX, mouseY, false, 0, true, I18n.m_118938_((String)"tooltip.toms_storage.amount", (Object[])new Object[]{this.stack.getQuantity()}));
                } else {
                    gui.renderItemInGui(st, this.stack.getStack(), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition, mouseX, mouseY, false, 0, true, new String[0]);
                }
            }
            return mouseX >= gui.getGuiLeft() + this.xDisplayPosition - 1 && mouseY >= gui.getGuiTop() + this.yDisplayPosition - 1 && mouseX < gui.getGuiLeft() + this.xDisplayPosition + 17 && mouseY < gui.getGuiTop() + this.yDisplayPosition + 17;
        }

        private void drawStackSize(PoseStack st, Font fr, long size, int x, int y) {
            float scaleFactor = 0.6f;
            RenderSystem.m_69465_();
            RenderSystem.m_69461_();
            String stackSize = ContainerStorageTerminal.formatNumber(size);
            st.m_85836_();
            st.m_85841_(scaleFactor, scaleFactor, scaleFactor);
            st.m_85837_(0.0, 0.0, 450.0);
            float inverseScaleFactor = 1.0f / scaleFactor;
            int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.m_92895_(stackSize) * scaleFactor) * inverseScaleFactor);
            int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
            fr.m_92750_(st, stackSize, (float)X, (float)Y, 0xFFFFFF);
            st.m_85849_();
            RenderSystem.m_69482_();
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }
}

