/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jei;

import com.google.common.base.Function;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.storagemod.gui.ContainerCraftingTerminal;
import com.tom.storagemod.jei.IJEIAutoFillTerminal;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class CraftingTerminalTransferHandler
implements IRecipeTransferHandler {
    private final Class<? extends AbstractContainerMenu> containerClass;
    private static final List<Class<? extends AbstractContainerMenu>> containerClasses = new ArrayList<Class<? extends AbstractContainerMenu>>();
    private static final Function<IRecipeLayout, ItemStack[][]> transferFunc = new Function<IRecipeLayout, ItemStack[][]>(){

        public ItemStack[][] apply(IRecipeLayout t) {
            ArrayList<ItemStack[]> inputs = new ArrayList<ItemStack[]>();
            IGuiItemStackGroup itemStackGroup = t.getItemStacks();
            for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
                if (!ingredient.isInput()) continue;
                if (!ingredient.getAllIngredients().isEmpty() && ingredient.getAllIngredients().get(0) != null) {
                    inputs.add(ingredient.getAllIngredients().toArray(new ItemStack[0]));
                    continue;
                }
                inputs.add(null);
            }
            return (ItemStack[][])inputs.toArray((T[])new ItemStack[0][]);
        }
    };
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }

        public void showError(PoseStack stack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        }
    };

    public CraftingTerminalTransferHandler(Class<? extends AbstractContainerMenu> containerClass) {
        this.containerClass = containerClass;
    }

    public Class<? extends AbstractContainerMenu> getContainerClass() {
        return this.containerClass;
    }

    public IRecipeTransferError transferRecipe(AbstractContainerMenu container, Object recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IJEIAutoFillTerminal) {
            if (doTransfer) {
                ItemStack[][] stacks = (ItemStack[][])transferFunc.apply((Object)recipeLayout);
                CompoundTag compound = new CompoundTag();
                ListTag list = new ListTag();
                for (int i = 0; i < stacks.length; ++i) {
                    if (stacks[i] == null) continue;
                    CompoundTag CompoundNBT = new CompoundTag();
                    CompoundNBT.m_128344_("s", (byte)i);
                    for (int j = 0; j < stacks[i].length && j < 3; ++j) {
                        if (stacks[i][j] == null || stacks[i][j].m_41619_()) continue;
                        CompoundTag tag = new CompoundTag();
                        stacks[i][j].m_41739_(tag);
                        CompoundNBT.m_128365_("i" + j, (Tag)tag);
                    }
                    CompoundNBT.m_128344_("l", (byte)Math.min(3, stacks[i].length));
                    list.add((Object)CompoundNBT);
                }
                compound.m_128365_("i", (Tag)list);
                ((IJEIAutoFillTerminal)container).sendMessage(compound);
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        for (int i = 0; i < containerClasses.size(); ++i) {
            recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTerminalTransferHandler(containerClasses.get(i)), VanillaRecipeCategoryUid.CRAFTING);
        }
    }

    public Class getRecipeClass() {
        return Object.class;
    }

    static {
        containerClasses.add(ContainerCraftingTerminal.class);
    }
}

