/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.TickerUtil;
import com.tom.storagemod.block.ITrim;
import com.tom.storagemod.tile.IProxy;
import com.tom.storagemod.tile.InfoHandler;
import com.tom.storagemod.tile.TileEntityInventoryCableConnector;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryConnector
extends BlockEntity
implements TickerUtil.TickableServer {
    private List<LazyOptional<IItemHandler>> handlers = new ArrayList<LazyOptional<IItemHandler>>();
    private List<LinkedInv> linkedInvs = new ArrayList<LinkedInv>();
    private LazyOptional<IItemHandler> invHandler;
    private int[] invSizes = new int[0];
    private int invSize;

    public TileEntityInventoryConnector(BlockPos pos, BlockState state) {
        super(StorageMod.connectorTile, pos, state);
    }

    @Override
    public void updateServer() {
        long time = this.f_58857_.m_46467_();
        if (time % 20L == 0L) {
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            toCheck.add(this.f_58858_);
            checkedBlocks.add(this.f_58858_);
            this.handlers.clear();
            HashSet<LinkedInv> toRM = new HashSet<LinkedInv>();
            for (LinkedInv linkedInv : this.linkedInvs) {
                if (linkedInv.time + 40L < time) {
                    toRM.add(linkedInv);
                    continue;
                }
                this.handlers.add(linkedInv.handler.get());
            }
            this.linkedInvs.removeAll(toRM);
            Collections.sort(this.linkedInvs);
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                for (Direction d : Direction.values()) {
                    ChestType type;
                    Block block;
                    BlockPos p = cp.m_142300_(d);
                    if (checkedBlocks.contains(p) || !(p.m_123331_((Vec3i)this.f_58858_) < (double)Config.invRange)) continue;
                    checkedBlocks.add(p);
                    BlockState state = this.f_58857_.m_8055_(p);
                    if (state.m_60734_() instanceof ITrim) {
                        toCheck.add(p);
                        continue;
                    }
                    BlockEntity te = this.f_58857_.m_7702_(p);
                    if (te instanceof TileEntityInventoryConnector || te instanceof TileEntityInventoryProxy || te instanceof TileEntityInventoryCableConnector || te == null || Config.onlyTrims) continue;
                    LazyOptional inv = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.m_122424_());
                    if (te instanceof ChestBlockEntity && (block = state.m_60734_()) instanceof ChestBlock && (type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE) {
                        ChestType otype;
                        BlockPos opos = p.m_142300_(ChestBlock.m_51584_((BlockState)state));
                        BlockState ostate = this.m_58904_().m_8055_(opos);
                        if (state.m_60734_() == ostate.m_60734_() && (otype = (ChestType)ostate.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE && type != otype && state.m_61143_((Property)ChestBlock.f_51478_) == ostate.m_61143_((Property)ChestBlock.f_51478_)) {
                            toCheck.add(opos);
                            checkedBlocks.add(opos);
                        }
                    }
                    if (inv.isPresent()) {
                        InvHandler ih;
                        IItemHandler ihr;
                        IItemHandler blockHandler = (IItemHandler)inv.orElse(null);
                        if (blockHandler == null) {
                            StorageMod.LOGGER.warn("Broken modded block at " + p + " in " + this.f_58857_.m_46472_().m_135782_().toString() + " block id: " + state.m_60734_().delegate.name().toString());
                        }
                        if ((ihr = IProxy.resolve(blockHandler)) instanceof InvHandler && this.checkHandlers(ih = (InvHandler)ihr, 0)) {
                            if (this.handlers.contains(InfoHandler.INSTANCE)) continue;
                            this.handlers.add(InfoHandler.INSTANCE);
                            continue;
                        }
                        toCheck.add(p);
                        this.handlers.add((LazyOptional<IItemHandler>)inv);
                    }
                    if (!Config.multiblockInvs.contains(state.m_60734_())) continue;
                    this.skipBlocks(p, checkedBlocks, toCheck, state.m_60734_());
                }
            }
            if (this.invSizes.length != this.handlers.size()) {
                this.invSizes = new int[this.handlers.size()];
            }
            this.invSize = 0;
            for (int i = 0; i < this.invSizes.length; ++i) {
                int s;
                IItemHandler iItemHandler = (IItemHandler)this.handlers.get(i).orElse(null);
                if (iItemHandler == null) {
                    this.invSizes[i] = 0;
                    continue;
                }
                this.invSizes[i] = s = iItemHandler.getSlots();
                this.invSize += s;
            }
        }
    }

    private void skipBlocks(BlockPos pos, Set<BlockPos> checkedBlocks, Stack<BlockPos> edges, Block block) {
        Stack<BlockPos> toCheck = new Stack<BlockPos>();
        toCheck.add(pos);
        edges.add(pos);
        while (!toCheck.isEmpty()) {
            BlockPos cp = (BlockPos)toCheck.pop();
            for (Direction d : Direction.values()) {
                BlockState state;
                BlockPos p = cp.m_142300_(d);
                if (checkedBlocks.contains(p) || !(p.m_123331_((Vec3i)this.f_58858_) < (double)Config.invRange) || (state = this.f_58857_.m_8055_(p)).m_60734_() != block) continue;
                checkedBlocks.add(p);
                edges.add(p);
                toCheck.add(p);
            }
        }
    }

    private boolean checkHandlers(InvHandler ih, int depth) {
        if (depth > 3) {
            return true;
        }
        for (LazyOptional<IItemHandler> lo : ih.getHandlers()) {
            IItemHandler ihr = IProxy.resolve((IItemHandler)lo.orElse(null));
            if (!(ihr instanceof InvHandler) || !this.checkHandlers((InvHandler)ihr, depth + 1)) continue;
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventory().cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IItemHandler> getInventory() {
        if (this.invHandler == null) {
            this.invHandler = LazyOptional.of(() -> new InvHandler());
        }
        return this.invHandler;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void addLinked(LinkedInv inv) {
        this.linkedInvs.add(inv);
    }

    public void unLink(LinkedInv linv) {
        this.linkedInvs.remove(linv);
    }

    public int getFreeSlotCount() {
        return (Integer)this.getInventory().lazyMap(inv -> {
            int empty = 0;
            for (int i = 0; i < this.invSize; ++i) {
                if (!inv.getStackInSlot(i).m_41619_()) continue;
                ++empty;
            }
            return empty;
        }).orElse((Object)0);
    }

    public int getInvSize() {
        return this.invSize;
    }

    public static class LinkedInv
    implements Comparable<LinkedInv> {
        public Supplier<LazyOptional<IItemHandler>> handler;
        public long time;
        public int priority;

        @Override
        public int compareTo(LinkedInv o) {
            return Integer.compare(this.priority, o.priority);
        }
    }

    private class InvHandler
    implements IItemHandler {
        private boolean calling;

        private InvHandler() {
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.calling) {
                return false;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                boolean r = ((IItemHandler)TileEntityInventoryConnector.this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).isItemValid(slot, stack);
                this.calling = false;
                return r;
            }
            this.calling = false;
            return false;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.calling) {
                return stack;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                ItemStack s = ((IItemHandler)TileEntityInventoryConnector.this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).insertItem(slot, stack, simulate);
                this.calling = false;
                return s;
            }
            this.calling = false;
            return stack;
        }

        public ItemStack getStackInSlot(int slot) {
            if (this.calling) {
                return ItemStack.f_41583_;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                ItemStack s = ((IItemHandler)TileEntityInventoryConnector.this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).getStackInSlot(slot);
                this.calling = false;
                return s;
            }
            this.calling = false;
            return ItemStack.f_41583_;
        }

        public int getSlots() {
            return TileEntityInventoryConnector.this.invSize;
        }

        public int getSlotLimit(int slot) {
            if (this.calling) {
                return 0;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                int r = ((IItemHandler)TileEntityInventoryConnector.this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).getSlotLimit(slot);
                this.calling = false;
                return r;
            }
            this.calling = false;
            return 0;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.calling) {
                return ItemStack.f_41583_;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                ItemStack s = ((IItemHandler)TileEntityInventoryConnector.this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).extractItem(slot, amount, simulate);
                this.calling = false;
                return s;
            }
            this.calling = false;
            return ItemStack.f_41583_;
        }

        public List<LazyOptional<IItemHandler>> getHandlers() {
            return TileEntityInventoryConnector.this.handlers;
        }
    }
}

