/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge;

import java.util.Random;
import net.blay09.mods.balm.api.BalmHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemHandlerHelper;

public class ForgeBalmHooks
implements BalmHooks {
    @Override
    public boolean saplingGrowTree(Level level, Random random, BlockPos pos) {
        return ForgeEventFactory.saplingGrowTree((LevelAccessor)level, (Random)random, (BlockPos)pos);
    }

    @Override
    public boolean growCrop(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        if (player != null) {
            return BoneMealItem.applyBonemeal((ItemStack)itemStack, (Level)level, (BlockPos)pos, (Player)player);
        }
        return BoneMealItem.m_40627_((ItemStack)itemStack, (Level)level, (BlockPos)pos);
    }

    @Override
    public CompoundTag getPersistentData(Entity entity) {
        CompoundTag persistentData = entity.getPersistentData();
        if (entity instanceof Player) {
            CompoundTag persistedTag = persistentData.m_128469_("PlayerPersisted");
            persistentData.m_128365_("PlayerPersisted", (Tag)persistedTag);
            persistentData = persistedTag;
        }
        CompoundTag balmData = persistentData.m_128469_("BalmData");
        persistentData.m_128365_("BalmData", (Tag)balmData);
        return balmData;
    }

    @Override
    public void curePotionEffects(LivingEntity entity, ItemStack curativeItem) {
        entity.curePotionEffects(curativeItem);
    }

    @Override
    public boolean isFakePlayer(Player player) {
        return player instanceof FakePlayer;
    }

    @Override
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.getContainerItem();
    }

    @Override
    public DyeColor getColor(ItemStack itemStack) {
        return DyeColor.getColor((ItemStack)itemStack);
    }

    @Override
    public boolean canItemsStack(ItemStack first, ItemStack second) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)first, (ItemStack)second);
    }

    @Override
    public int getBurnTime(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44108_);
    }

    @Override
    public void firePlayerCraftingEvent(Player player, ItemStack crafted, Container craftMatrix) {
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)crafted, (Container)craftMatrix);
    }

    @Override
    public boolean useFluidTank(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_());
    }

    @Override
    public boolean isShield(ItemStack itemStack) {
        return itemStack.m_41720_().canPerformAction(itemStack, ToolActions.SHIELD_BLOCK);
    }

    @Override
    public void setForcedPose(Player player, Pose pose) {
        player.setForcedPose(pose);
    }
}

