/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.ExtraHeartRenderHandler;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.mantle.client.model.FallbackModelLoader;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.connected.ConnectedModel;
import slimeknights.mantle.client.model.fluid.FluidTextureModel;
import slimeknights.mantle.client.model.fluid.FluidsModel;
import slimeknights.mantle.client.model.inventory.InventoryModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.registration.MantleRegistrations;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.util.OffhandCooldownTracker;

@Mod.EventBusSubscriber(modid="mantle", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    private static final Function<OffhandCooldownTracker, Float> COOLDOWN_TRACKER = OffhandCooldownTracker::getCooldown;

    @SubscribeEvent
    static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(MantleRegistrations.SIGN, SignRenderer::new);
    }

    @SubscribeEvent
    static void registerListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ModelHelper.LISTENER);
        event.registerReloadListener((PreparableReloadListener)new BookLoader());
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> RegistrationHelper.forEachWoodType(Sheets::addWoodType));
        BookLoader.registerBook(Mantle.getResource("test"), new FileRepository(Mantle.getResource("books/test")));
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("connected"), (IModelLoader)ConnectedModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("item_layer"), (IModelLoader)MantleItemLayerModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("colored_block"), (IModelLoader)ColoredBlockModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("fallback"), (IModelLoader)FallbackModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("nbt_key"), (IModelLoader)NBTKeyModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("retextured"), (IModelLoader)RetexturedModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("fluid_texture"), (IModelLoader)FluidTextureModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("inventory"), (IModelLoader)InventoryModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("fluids"), (IModelLoader)FluidsModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ExtraHeartRenderHandler());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderGameOverlayEvent.PostLayer.class, ClientEvents::renderOffhandAttackIndicator);
    }

    private static void renderOffhandAttackIndicator(RenderGameOverlayEvent.PostLayer event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Options settings = minecraft.f_91066_;
        if (minecraft.f_91074_ == null || minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR || settings.f_92029_ == AttackIndicatorStatus.OFF) {
            return;
        }
        IIngameOverlay overlay = event.getOverlay();
        if (overlay != ForgeIngameGui.CROSSHAIR_ELEMENT && overlay != ForgeIngameGui.HOTBAR_ELEMENT) {
            return;
        }
        float cooldown = minecraft.f_91074_.getCapability(OffhandCooldownTracker.CAPABILITY).filter(OffhandCooldownTracker::isEnabled).map(COOLDOWN_TRACKER).orElse(Float.valueOf(1.0f)).floatValue();
        if (cooldown >= 1.0f) {
            return;
        }
        PoseStack matrixStack = event.getMatrixStack();
        switch (settings.f_92029_) {
            case CROSSHAIR: {
                if (overlay != ForgeIngameGui.CROSSHAIR_ELEMENT || !minecraft.f_91066_.m_92176_().m_90612_() || settings.f_92063_ && !settings.f_92062_ && !minecraft.f_91074_.m_36330_() && !settings.f_92047_) break;
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int scaledHeight = minecraft.m_91268_().m_85446_();
                int y = scaledHeight / 2 - 14 + 2 * (scaledHeight % 2);
                int x = minecraft.m_91268_().m_85445_() / 2 - 8;
                int width = (int)(cooldown * 17.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                minecraft.f_91065_.m_93228_(matrixStack, x, y, 36, 94, 16, 4);
                minecraft.f_91065_.m_93228_(matrixStack, x, y, 52, 94, width, 4);
                break;
            }
            case HOTBAR: {
                if (overlay != ForgeIngameGui.HOTBAR_ELEMENT || minecraft.f_91075_ != minecraft.f_91074_) break;
                int centerWidth = minecraft.m_91268_().m_85445_() / 2;
                int y = minecraft.m_91268_().m_85446_() - 20;
                int x = minecraft.f_91074_.m_5737_() == HumanoidArm.RIGHT ? centerWidth - 91 - 22 - 32 : centerWidth + 91 + 6 + 32;
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                int l1 = (int)(cooldown * 19.0f);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                minecraft.f_91065_.m_93228_(matrixStack, x, y, 0, 94, 18, 18);
                minecraft.f_91065_.m_93228_(matrixStack, x, y + 18 - l1, 18, 112 - l1, 18, l1);
            }
        }
    }
}

