/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.TagCollectionArgument;
import slimeknights.mantle.command.ViewTagCommand;

public class DumpTagCommand {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Dynamic2CommandExceptionType ERROR_READING_TAG = new Dynamic2CommandExceptionType((type, name) -> new TranslatableComponent("command.mantle.dump_tag.read_error", new Object[]{type, name}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Commands.m_82129_((String)"type", (ArgumentType)TagCollectionArgument.collection()).then(Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleCommand.VALID_TAGS).executes(DumpTagCommand::run)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        TagCollectionArgument.Result<?> type = TagCollectionArgument.getResult(context, "type");
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        ResourceManager manager = ((CommandSourceStack)context.getSource()).m_81377_().m_177941_();
        ResourceLocation path = new ResourceLocation(name.m_135827_(), "tags/" + type.getTagFolder() + "/" + name.m_135815_() + ".json");
        try {
            List resources = manager.m_7396_(path);
            Tag.Builder builder = Tag.Builder.m_13304_();
            int tagsProcessed = 0;
            for (Resource resource : resources) {
                try {
                    InputStream inputstream = resource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                        if (json == null) {
                            Mantle.logger.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)type.getName(), (Object)name, (Object)path, (Object)resource.m_7816_());
                            continue;
                        }
                        builder.m_13312_(json, resource.m_7816_());
                        ++tagsProcessed;
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                catch (IOException | RuntimeException ex) {
                    Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)type.getName(), (Object)name, (Object)path, (Object)resource.m_7816_(), (Object)ex);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
            TranslatableComponent message = new TranslatableComponent("command.mantle.dump_tag.success", new Object[]{type.getName(), name});
            ((CommandSourceStack)context.getSource()).m_81354_((Component)message, true);
            Mantle.logger.info("Tag dump of {} tag '{}':\n{}", (Object)type.getName(), (Object)name, (Object)GSON.toJson((JsonElement)builder.m_13334_()));
            return tagsProcessed;
        }
        catch (IOException | RuntimeException ex) {
            if (type.getCollection().m_13404_(name) == null) {
                throw ViewTagCommand.TAG_NOT_FOUND.create((Object)type.getName(), (Object)name);
            }
            Mantle.logger.error("Couldn't read {} tag list {} from {}", (Object)type.getName(), (Object)name, (Object)path, (Object)ex);
            throw ERROR_READING_TAG.create((Object)type.getName(), (Object)name);
        }
    }
}

