/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.BookTestCommand;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpLootModifiers;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.TagCollectionArgument;
import slimeknights.mantle.command.TagsForCommand;
import slimeknights.mantle.command.ViewTagCommand;

public class MantleCommand {
    public static final int PERMISSION_EDIT_SPAWN = 1;
    public static final int PERMISSION_GAME_COMMANDS = 2;
    public static final int PERMISSION_PLAYER_COMMANDS = 3;
    public static final int PERMISSION_OWNER = 4;
    public static SuggestionProvider<CommandSourceStack> VALID_TAGS;
    public static SuggestionProvider<CommandSourceStack> REGISTRY_VALUES;
    public static SuggestionProvider<CommandSourceStack> REGISTERED_BOOKS;

    public static void init() {
        ArgumentTypes.m_121601_((String)"mantle:tag_collection", TagCollectionArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(TagCollectionArgument::collection));
        VALID_TAGS = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("valid_tags"), (context, builder) -> {
            TagCollectionArgument.Result result = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
            return SharedSuggestionProvider.m_82926_((Iterable)result.getCollection().m_13406_(), (SuggestionsBuilder)builder);
        });
        REGISTRY_VALUES = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("registry_values"), (context, builder) -> {
            TagCollectionArgument.Result result = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
            return SharedSuggestionProvider.m_82926_(result.getKeys(), (SuggestionsBuilder)builder);
        });
        REGISTERED_BOOKS = SuggestionProviders.m_121658_((ResourceLocation)Mantle.getResource("registered_books"), (context, builder) -> SharedSuggestionProvider.m_82926_(BookTestCommand.getBookSuggestions(), (SuggestionsBuilder)builder));
        MinecraftForge.EVENT_BUS.addListener(MantleCommand::registerCommand);
    }

    private static void register(LiteralArgumentBuilder<CommandSourceStack> root, String name, Consumer<LiteralArgumentBuilder<CommandSourceStack>> consumer) {
        LiteralArgumentBuilder subCommand = Commands.m_82127_((String)name);
        consumer.accept((LiteralArgumentBuilder<CommandSourceStack>)subCommand);
        root.then((ArgumentBuilder)subCommand);
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"mantle");
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "view_tag", ViewTagCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "dump_tag", DumpTagCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "dump_loot_modifiers", DumpLootModifiers::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "dump_all_tags", DumpAllTagsCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "tags_for", TagsForCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "book_test", BookTestCommand::register);
        event.getDispatcher().register(builder);
    }

    public static boolean requiresDebugInfoOrOp(CommandSourceStack source, int reducedDebugLevel) {
        return !source.m_81372_().m_46469_().m_46207_(GameRules.f_46145_) || source.m_6761_(reducedDebugLevel);
    }
}

