/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MergingJsonDataLoader<B>
implements ResourceManagerReloadListener {
    private static final Logger log = LogManager.getLogger(MergingJsonDataLoader.class);
    private static final int JSON_LENGTH = ".json".length();
    @VisibleForTesting
    protected final Gson gson;
    @VisibleForTesting
    protected final String folder;
    @VisibleForTesting
    protected final Function<ResourceLocation, B> builderConstructor;

    protected abstract void parse(B var1, ResourceLocation var2, JsonElement var3) throws JsonSyntaxException;

    protected abstract void finishLoad(Map<ResourceLocation, B> var1, ResourceManager var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager manager) {
        HashMap<ResourceLocation, B> map = new HashMap<ResourceLocation, B>();
        for (ResourceLocation filePath : manager.m_6540_(this.folder, fileName -> fileName.endsWith(".json"))) {
            String path = filePath.m_135815_();
            ResourceLocation id = new ResourceLocation(filePath.m_135827_(), path.substring(this.folder.length() + 1, path.length() - JSON_LENGTH));
            try {
                for (Resource resource : manager.m_7396_(filePath)) {
                    try {
                        InputStream inputstream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            JsonElement json = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                            if (json == null) {
                                log.error("Couldn't load data file {} from {} in data pack {} as its null or empty", (Object)id, (Object)filePath, (Object)resource.m_7816_());
                                continue;
                            }
                            B builder = map.computeIfAbsent(id, this.builderConstructor);
                            this.parse(builder, id, json);
                        }
                        finally {
                            if (inputstream == null) continue;
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException ex) {
                        log.error("Couldn't parse data file {} from {} in data pack {}", (Object)id, (Object)filePath, (Object)resource.m_7816_(), (Object)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException ex) {
                log.error("Couldn't read material trait mapping {} from {}", (Object)id, (Object)filePath, (Object)ex);
            }
        }
        this.finishLoad(map, manager);
    }

    public MergingJsonDataLoader(Gson gson, String folder, Function<ResourceLocation, B> builderConstructor) {
        this.gson = gson;
        this.folder = folder;
        this.builderConstructor = builderConstructor;
    }
}

