/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.MantleRecipeSerializers;

public class ShapedRetexturedRecipeBuilder {
    private final ShapedRecipeBuilder parent;
    private Ingredient texture;
    private boolean matchAll;

    public ShapedRetexturedRecipeBuilder setSource(Ingredient texture) {
        this.texture = texture;
        return this;
    }

    public ShapedRetexturedRecipeBuilder setSource(Tag<Item> tag) {
        this.texture = Ingredient.m_43911_(tag);
        return this;
    }

    public ShapedRetexturedRecipeBuilder setMatchAll() {
        this.matchAll = true;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.validate();
        this.parent.m_176498_(base -> consumer.accept(new Result((FinishedRecipe)base, this.texture, this.matchAll)));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation location) {
        this.validate();
        this.parent.m_142700_(base -> consumer.accept(new Result((FinishedRecipe)base, this.texture, this.matchAll)), location);
    }

    private void validate() {
        if (this.texture == null) {
            throw new IllegalStateException("No texture defined for texture recipe");
        }
    }

    private ShapedRetexturedRecipeBuilder(ShapedRecipeBuilder parent) {
        this.parent = parent;
    }

    public static ShapedRetexturedRecipeBuilder fromShaped(ShapedRecipeBuilder parent) {
        return new ShapedRetexturedRecipeBuilder(parent);
    }

    private static class Result
    implements FinishedRecipe {
        private final FinishedRecipe base;
        private final Ingredient texture;
        private final boolean matchAll;

        private Result(FinishedRecipe base, Ingredient texture, boolean matchAll) {
            this.base = base;
            this.texture = texture;
            this.matchAll = matchAll;
        }

        public RecipeSerializer<?> m_6637_() {
            return MantleRecipeSerializers.CRAFTING_SHAPED_RETEXTURED;
        }

        public ResourceLocation m_6445_() {
            return this.base.m_6445_();
        }

        public void m_7917_(JsonObject json) {
            this.base.m_7917_(json);
            json.add("texture", this.texture.m_43942_());
            json.addProperty("match_all", Boolean.valueOf(this.matchAll));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.base.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.base.m_6448_();
        }
    }
}

