/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import slimeknights.mantle.recipe.helper.TagPreference;

public abstract class ItemOutput
implements Supplier<ItemStack> {
    @Override
    public abstract ItemStack get();

    public abstract JsonElement serialize();

    public static ItemOutput fromStack(ItemStack stack) {
        return new OfStack(stack);
    }

    public static ItemOutput fromItem(ItemLike item, int count) {
        return new OfItem(item.m_5456_(), count);
    }

    public static ItemOutput fromItem(ItemLike item) {
        return ItemOutput.fromItem(item, 1);
    }

    public static ItemOutput fromTag(Tag<Item> tag, int count) {
        return new OfTagPreference(tag, count);
    }

    public static ItemOutput fromJson(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return ItemOutput.fromItem((ItemLike)GsonHelper.m_13874_((JsonElement)element, (String)"item"));
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Invalid item output, must be a string or an object");
        }
        JsonObject json = element.getAsJsonObject();
        if (json.has("tag")) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"tag");
            Tag tag = SerializationTags.m_13199_().m_144458_(Registry.f_122904_, new ResourceLocation(name), n -> new JsonSyntaxException("Unknown tag " + n + " for item output"));
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return ItemOutput.fromTag((Tag<Item>)tag, count);
        }
        return ItemOutput.fromStack(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.get());
    }

    public static ItemOutput read(FriendlyByteBuf buffer) {
        return ItemOutput.fromStack(buffer.m_130267_());
    }

    private static class OfStack
    extends ItemOutput {
        private final ItemStack stack;

        @Override
        public ItemStack get() {
            return this.stack;
        }

        @Override
        public JsonElement serialize() {
            String itemName = Objects.requireNonNull(this.stack.m_41720_().getRegistryName()).toString();
            int count = this.stack.m_41613_();
            if (this.stack.m_41782_() || count > 1) {
                CompoundTag nbt;
                JsonObject jsonResult = new JsonObject();
                jsonResult.addProperty("item", itemName);
                if (count > 1) {
                    jsonResult.addProperty("count", (Number)count);
                }
                if ((nbt = this.stack.m_41783_()) != null) {
                    jsonResult.addProperty("nbt", nbt.toString());
                }
                return jsonResult;
            }
            return new JsonPrimitive(itemName);
        }

        public OfStack(ItemStack stack) {
            this.stack = stack;
        }
    }

    private static class OfItem
    extends ItemOutput {
        private final Item item;
        private final int count;
        private ItemStack cachedStack;

        @Override
        public ItemStack get() {
            if (this.cachedStack == null) {
                this.cachedStack = new ItemStack((ItemLike)this.item, this.count);
            }
            return this.cachedStack;
        }

        @Override
        public JsonElement serialize() {
            String itemName = Objects.requireNonNull(this.item.getRegistryName()).toString();
            if (this.count > 1) {
                JsonObject json = new JsonObject();
                json.addProperty("item", itemName);
                json.addProperty("count", (Number)this.count);
                return json;
            }
            return new JsonPrimitive(itemName);
        }

        public OfItem(Item item, int count) {
            this.item = item;
            this.count = count;
        }
    }

    private static class OfTagPreference
    extends ItemOutput {
        private final Tag<Item> tag;
        private final int count;
        private ItemStack cachedResult = null;

        @Override
        public ItemStack get() {
            if (this.cachedResult == null) {
                this.cachedResult = TagPreference.getItems().getPreference(this.tag).map(item -> new ItemStack((ItemLike)item, this.count)).orElse(ItemStack.f_41583_);
            }
            return this.cachedResult;
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("tag", SerializationTags.m_13199_().m_144454_(Registry.f_122904_, this.tag, () -> new IllegalStateException("Unregistered tag " + this.tag)).toString());
            if (this.count != 1) {
                json.addProperty("count", (Number)this.count);
            }
            return json;
        }

        public OfTagPreference(Tag<Item> tag, int count) {
            this.tag = tag;
            this.count = count;
        }
    }
}

