/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.util.LogicHelper;

public class TagPreference<T extends IForgeRegistryEntry<T>> {
    private static final ResourceLocation DEFAULT_ID = new ResourceLocation("zzzzz:zzzzz");
    private static final Map<ResourceKey<?>, TagPreference<?>> PREFERENCE_MAP = new IdentityHashMap();
    private static final Comparator<IForgeRegistryEntry<?>> ENTRY_COMPARATOR = (a, b) -> {
        int indexB;
        ResourceLocation idA = Objects.requireNonNullElse(a.getRegistryName(), DEFAULT_ID);
        ResourceLocation idB = Objects.requireNonNullElse(b.getRegistryName(), DEFAULT_ID);
        List entries = (List)Config.TAG_PREFERENCES.get();
        int size = entries.size();
        int indexA = LogicHelper.defaultIf(entries.indexOf(idA.m_135827_()), -1, size);
        if (indexA != (indexB = LogicHelper.defaultIf(entries.indexOf(idB.m_135827_()), -1, size))) {
            return Integer.compare(indexA, indexB);
        }
        return idA.compareNamespaced(idB);
    };
    private final ResourceKey<Registry<T>> key;
    private final Map<ResourceLocation, Optional<T>> preferenceCache = new HashMap<ResourceLocation, Optional<T>>();

    public static <T extends IForgeRegistryEntry<T>> TagPreference<T> getInstance(ResourceKey<Registry<T>> key) {
        return PREFERENCE_MAP.computeIfAbsent(key, c -> new TagPreference(key));
    }

    public static TagPreference<Item> getItems() {
        return TagPreference.getInstance(Registry.f_122904_);
    }

    public static TagPreference<Fluid> getFluids() {
        return TagPreference.getInstance(Registry.f_122899_);
    }

    private TagPreference(ResourceKey<Registry<T>> key) {
        this.key = key;
        MinecraftForge.EVENT_BUS.addListener(this::clearCache);
    }

    private void clearCache(TagsUpdatedEvent event) {
        this.preferenceCache.clear();
    }

    private Optional<T> getUncachedPreference(Tag<T> tag) {
        if (tag instanceof Tags.IOptionalNamedTag && ((Tags.IOptionalNamedTag)tag).isDefaulted()) {
            return Optional.empty();
        }
        List elements = tag.m_6497_();
        if (elements.isEmpty()) {
            return Optional.empty();
        }
        if (elements.size() == 1) {
            return Optional.of((IForgeRegistryEntry)elements.get(0));
        }
        return elements.stream().min(ENTRY_COMPARATOR).map(t -> t);
    }

    public Optional<T> getPreference(Tag<T> tag) {
        ResourceLocation tagName = SerializationTags.m_13199_().m_144452_(this.key).m_7473_(tag);
        if (tagName != null) {
            return this.preferenceCache.computeIfAbsent(tagName, name -> this.getUncachedPreference(tag));
        }
        Mantle.logger.warn("Attempting to get tag preference for unregistered tag {}", tag);
        return this.getUncachedPreference(tag);
    }
}

