/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public class IngredientDifference
extends Ingredient {
    public static final ResourceLocation ID = Mantle.getResource("difference");
    public static final IIngredientSerializer<IngredientDifference> SERIALIZER = new Serializer();
    private final Ingredient base;
    private final Ingredient subtracted;
    private ItemStack[] filteredMatchingStacks;
    private IntList packedMatchingStacks;

    protected IngredientDifference(Ingredient base, Ingredient subtracted) {
        super(Stream.empty());
        this.base = base;
        this.subtracted = subtracted;
    }

    public static IngredientDifference difference(Ingredient base, Ingredient subtracted) {
        return new IngredientDifference(base, subtracted);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return this.base.test(stack) && !this.subtracted.test(stack);
    }

    public ItemStack[] m_43908_() {
        if (this.filteredMatchingStacks == null) {
            this.filteredMatchingStacks = (ItemStack[])Arrays.stream(this.base.m_43908_()).filter(stack -> !this.subtracted.test(stack)).toArray(ItemStack[]::new);
        }
        return this.filteredMatchingStacks;
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    public boolean isSimple() {
        return this.base.isSimple() && this.subtracted.isSimple();
    }

    protected void invalidate() {
        super.invalidate();
        this.filteredMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList m_43931_() {
        if (this.packedMatchingStacks == null) {
            ItemStack[] matchingStacks = this.m_43908_();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (ItemStack stack : matchingStacks) {
                this.packedMatchingStacks.add(StackedContents.m_36496_((ItemStack)stack));
            }
            this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("base", this.base.m_43942_());
        json.add("subtracted", this.subtracted.m_43942_());
        return json;
    }

    public IIngredientSerializer<IngredientDifference> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<IngredientDifference> {
        private Serializer() {
        }

        public IngredientDifference parse(JsonObject json) {
            Ingredient base = Ingredient.m_43917_((JsonElement)JsonHelper.getElement(json, "base"));
            Ingredient without = Ingredient.m_43917_((JsonElement)JsonHelper.getElement(json, "subtracted"));
            return new IngredientDifference(base, without);
        }

        public IngredientDifference parse(FriendlyByteBuf buffer) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient without = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new IngredientDifference(base, without);
        }

        public void write(FriendlyByteBuf buffer, IngredientDifference ingredient) {
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient.base);
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient.subtracted);
        }
    }
}

