/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public class IngredientIntersection
extends Ingredient {
    public static final ResourceLocation ID = Mantle.getResource("intersection");
    public static final IIngredientSerializer<IngredientIntersection> SERIALIZER = new Serializer();
    private final List<Ingredient> ingredients;
    private ItemStack[] intersectedMatchingStacks;
    private IntList packedMatchingStacks;

    protected IngredientIntersection(List<Ingredient> ingredients) {
        super(Stream.empty());
        this.ingredients = ingredients;
    }

    public static IngredientIntersection intersection(List<Ingredient> ingredients) {
        return new IngredientIntersection(ingredients);
    }

    public static IngredientIntersection intersection(Ingredient ... ingredients) {
        return IngredientIntersection.intersection((List<Ingredient>)ImmutableList.copyOf((Object[])ingredients));
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.test(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] m_43908_() {
        if (this.intersectedMatchingStacks == null) {
            this.intersectedMatchingStacks = this.ingredients.isEmpty() ? new ItemStack[0] : (ItemStack[])Arrays.stream(this.ingredients.get(0).m_43908_()).filter(stack -> {
                for (int i = 1; i < this.ingredients.size(); ++i) {
                    if (this.ingredients.get(i).test(stack)) continue;
                    return false;
                }
                return true;
            }).toArray(ItemStack[]::new);
        }
        return this.intersectedMatchingStacks;
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    public boolean isSimple() {
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.isSimple()) continue;
            return false;
        }
        return true;
    }

    protected void invalidate() {
        super.invalidate();
        this.intersectedMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList m_43931_() {
        if (this.packedMatchingStacks == null) {
            ItemStack[] matchingStacks = this.m_43908_();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (ItemStack stack : matchingStacks) {
                this.packedMatchingStacks.add(StackedContents.m_36496_((ItemStack)stack));
            }
            this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        JsonArray array = new JsonArray();
        for (Ingredient ingredient : this.ingredients) {
            array.add(ingredient.m_43942_());
        }
        json.add("ingredients", (JsonElement)array);
        return json;
    }

    public IIngredientSerializer<IngredientIntersection> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<IngredientIntersection> {
        private Serializer() {
        }

        public IngredientIntersection parse(JsonObject json) {
            List<Ingredient> ingredients = JsonHelper.parseList(json, "ingredients", (element, name) -> Ingredient.m_43917_((JsonElement)element));
            return new IngredientIntersection(ingredients);
        }

        public IngredientIntersection parse(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new IngredientIntersection((List<Ingredient>)builder.build());
        }

        public void write(FriendlyByteBuf buffer, IngredientIntersection intersection) {
            buffer.m_130130_(intersection.ingredients.size());
            for (Ingredient ingredient : intersection.ingredients) {
                CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient);
            }
        }
    }
}

