/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;

public class WoodBlockObject
extends FenceBuildingBlockObject {
    private final WoodType woodType;
    private final Supplier<? extends Block> log;
    private final Supplier<? extends Block> strippedLog;
    private final Supplier<? extends Block> wood;
    private final Supplier<? extends Block> strippedWood;
    private final Supplier<? extends FenceGateBlock> fenceGate;
    private final Supplier<? extends DoorBlock> door;
    private final Supplier<? extends TrapDoorBlock> trapdoor;
    private final Supplier<? extends PressurePlateBlock> pressurePlate;
    private final Supplier<? extends WoodButtonBlock> button;
    private final Supplier<? extends StandingSignBlock> sign;
    private final Supplier<? extends WallSignBlock> wallSign;
    private final Tags.IOptionalNamedTag<Block> logBlockTag;
    private final Tags.IOptionalNamedTag<Item> logItemTag;

    public WoodBlockObject(ResourceLocation name, WoodType woodType, BuildingBlockObject planks, Supplier<? extends Block> log, Supplier<? extends Block> strippedLog, Supplier<? extends Block> wood, Supplier<? extends Block> strippedWood, Supplier<? extends FenceBlock> fence, Supplier<? extends FenceGateBlock> fenceGate, Supplier<? extends DoorBlock> door, Supplier<? extends TrapDoorBlock> trapdoor, Supplier<? extends PressurePlateBlock> pressurePlate, Supplier<? extends WoodButtonBlock> button, Supplier<? extends StandingSignBlock> sign, Supplier<? extends WallSignBlock> wallSign) {
        super(planks, fence);
        this.woodType = woodType;
        this.log = log;
        this.strippedLog = strippedLog;
        this.wood = wood;
        this.strippedWood = strippedWood;
        this.fenceGate = fenceGate;
        this.door = door;
        this.trapdoor = trapdoor;
        this.pressurePlate = pressurePlate;
        this.button = button;
        this.sign = sign;
        this.wallSign = wallSign;
        ResourceLocation tagName = new ResourceLocation(name.m_135827_(), name.m_135815_() + "_logs");
        this.logBlockTag = BlockTags.createOptional((ResourceLocation)tagName);
        this.logItemTag = ItemTags.createOptional((ResourceLocation)tagName);
    }

    public WoodBlockObject(ResourceLocation name, WoodType woodType, BuildingBlockObject planks, Block log, Block strippedLog, Block wood, Block strippedWood, Block fence, Block fenceGate, Block door, Block trapdoor, Block pressurePlate, Block button, Block sign, Block wallSign) {
        super(planks, fence);
        this.woodType = woodType;
        this.log = RegistrationHelper.castDelegate(log.delegate);
        this.strippedLog = RegistrationHelper.castDelegate(strippedLog.delegate);
        this.wood = RegistrationHelper.castDelegate(wood.delegate);
        this.strippedWood = RegistrationHelper.castDelegate(strippedWood.delegate);
        this.fenceGate = RegistrationHelper.castDelegate(fenceGate.delegate);
        this.door = RegistrationHelper.castDelegate(door.delegate);
        this.trapdoor = RegistrationHelper.castDelegate(trapdoor.delegate);
        this.pressurePlate = RegistrationHelper.castDelegate(pressurePlate.delegate);
        this.button = RegistrationHelper.castDelegate(button.delegate);
        this.sign = RegistrationHelper.castDelegate(sign.delegate);
        this.wallSign = RegistrationHelper.castDelegate(wallSign.delegate);
        ResourceLocation tagName = new ResourceLocation(name.m_135827_(), name.m_135815_() + "_logs");
        this.logBlockTag = BlockTags.createOptional((ResourceLocation)tagName);
        this.logItemTag = ItemTags.createOptional((ResourceLocation)tagName);
    }

    public Block getLog() {
        return this.log.get();
    }

    public Block getStrippedLog() {
        return this.strippedLog.get();
    }

    public Block getWood() {
        return this.wood.get();
    }

    public Block getStrippedWood() {
        return this.strippedWood.get();
    }

    public FenceGateBlock getFenceGate() {
        return this.fenceGate.get();
    }

    public DoorBlock getDoor() {
        return this.door.get();
    }

    public TrapDoorBlock getTrapdoor() {
        return this.trapdoor.get();
    }

    public PressurePlateBlock getPressurePlate() {
        return this.pressurePlate.get();
    }

    public WoodButtonBlock getButton() {
        return this.button.get();
    }

    public StandingSignBlock getSign() {
        return this.sign.get();
    }

    public WallSignBlock getWallSign() {
        return this.wallSign.get();
    }

    @Override
    public List<Block> values() {
        return Arrays.asList((Block)this.get(), this.getSlab(), this.getStairs(), this.getFence(), this.getLog(), this.getStrippedLog(), this.getWood(), this.getStrippedWood(), this.getFenceGate(), this.getDoor(), this.getTrapdoor(), this.getPressurePlate(), this.getButton(), this.getSign(), this.getWallSign());
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public Tags.IOptionalNamedTag<Block> getLogBlockTag() {
        return this.logBlockTag;
    }

    public Tags.IOptionalNamedTag<Item> getLogItemTag() {
        return this.logItemTag;
    }

    public static enum WoodVariant {
        LOG,
        WOOD,
        PLANKS;

    }
}

