/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.worldgen.TBSurfaceRuleData;

public class GenerationSettings {
    private static SurfaceRules.RuleSource defaultOverworldSurfaceRules;
    private static SurfaceRules.RuleSource defaultNetherSurfaceRules;
    private static List<Pair<Integer, SurfaceRules.RuleSource>> beforeBedrockOverworldSurfaceRules;
    private static List<Pair<Integer, SurfaceRules.RuleSource>> afterBedrockOverworldSurfaceRules;
    private static List<Pair<Integer, SurfaceRules.RuleSource>> beforeBedrockNetherSurfaceRules;
    private static List<Pair<Integer, SurfaceRules.RuleSource>> afterBedrockNetherSurfaceRules;

    public static void setDefaultOverworldSurfaceRules(SurfaceRules.RuleSource rules) {
        defaultOverworldSurfaceRules = rules;
    }

    public static void setDefaultNetherSurfaceRules(SurfaceRules.RuleSource rules) {
        defaultNetherSurfaceRules = rules;
    }

    public static void addBeforeBedrockOverworldSurfaceRules(int priority, SurfaceRules.RuleSource rules) {
        beforeBedrockOverworldSurfaceRules.add((Pair<Integer, SurfaceRules.RuleSource>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addBeforeBedrockOverworldSurfaceRules(SurfaceRules.RuleSource rules) {
        GenerationSettings.addBeforeBedrockOverworldSurfaceRules(0, rules);
    }

    public static void addAfterBedrockOverworldSurfaceRules(int priority, SurfaceRules.RuleSource rules) {
        afterBedrockOverworldSurfaceRules.add((Pair<Integer, SurfaceRules.RuleSource>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addAfterBedrockOverworldSurfaceRules(SurfaceRules.RuleSource rules) {
        GenerationSettings.addAfterBedrockOverworldSurfaceRules(0, rules);
    }

    public static void addBeforeBedrockNetherSurfaceRules(int priority, SurfaceRules.RuleSource rules) {
        beforeBedrockNetherSurfaceRules.add((Pair<Integer, SurfaceRules.RuleSource>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addBeforeBedrockNetherSurfaceRules(SurfaceRules.RuleSource rules) {
        GenerationSettings.addBeforeBedrockNetherSurfaceRules(0, rules);
    }

    public static void addAfterBedrockNetherSurfaceRules(int priority, SurfaceRules.RuleSource rules) {
        afterBedrockNetherSurfaceRules.add((Pair<Integer, SurfaceRules.RuleSource>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addAfterBedrockNetherSurfaceRules(SurfaceRules.RuleSource rules) {
        GenerationSettings.addAfterBedrockNetherSurfaceRules(0, rules);
    }

    public static SurfaceRules.RuleSource getDefaultOverworldSurfaceRules() {
        if (defaultOverworldSurfaceRules == null) {
            defaultOverworldSurfaceRules = TBSurfaceRuleData.overworld();
        }
        return defaultOverworldSurfaceRules;
    }

    public static SurfaceRules.RuleSource getDefaultNetherSurfaceRules() {
        if (defaultNetherSurfaceRules == null) {
            defaultNetherSurfaceRules = TBSurfaceRuleData.nether();
        }
        return defaultNetherSurfaceRules;
    }

    public static List<SurfaceRules.RuleSource> getBeforeBedrockOverworldSurfaceRules() {
        return (List)beforeBedrockOverworldSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static List<SurfaceRules.RuleSource> getAfterBedrockOverworldSurfaceRules() {
        return (List)afterBedrockOverworldSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static List<SurfaceRules.RuleSource> getBeforeBedrockNetherSurfaceRules() {
        return (List)beforeBedrockNetherSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static List<SurfaceRules.RuleSource> getAfterBedrockNetherSurfaceRules() {
        return (List)afterBedrockNetherSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    static {
        beforeBedrockOverworldSurfaceRules = Lists.newArrayList();
        afterBedrockOverworldSurfaceRules = Lists.newArrayList();
        beforeBedrockNetherSurfaceRules = Lists.newArrayList();
        afterBedrockNetherSurfaceRules = Lists.newArrayList();
    }
}

