/*
 * Decompiled with CFR 0.152.
 */
package terrablender.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class LenientSimpleMapCodec<K, V>
extends MapCodec<Map<K, V>>
implements BaseMapCodec<K, V> {
    private final Codec<K> keyCodec;
    private final Codec<V> elementCodec;
    private final Keyable keys;

    public LenientSimpleMapCodec(Codec<K> keyCodec, Codec<V> elementCodec, Keyable keys) {
        this.keyCodec = keyCodec;
        this.elementCodec = elementCodec;
        this.keys = keys;
    }

    public Codec<K> keyCodec() {
        return this.keyCodec;
    }

    public Codec<V> elementCodec() {
        return this.elementCodec;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return this.keys.keys(ops);
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        ImmutableMap.Builder read = ImmutableMap.builder();
        ImmutableList.Builder failed = ImmutableList.builder();
        DataResult result = input.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> {
            DataResult v;
            DataResult k = this.keyCodec().parse(ops, pair.getFirst());
            DataResult entry = k.apply2stable(Pair::of, v = this.elementCodec().parse(ops, pair.getSecond()));
            if (entry.error().isPresent()) {
                return r;
            }
            entry.result().ifPresent(e -> read.put(e.getFirst(), e.getSecond()));
            return r.apply2stable((u, p) -> u, entry);
        }, (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
        ImmutableMap elements = read.build();
        return result.map(arg_0 -> LenientSimpleMapCodec.lambda$decode$5((Map)elements, arg_0)).setPartial((Object)elements);
    }

    public <T> RecordBuilder<T> encode(Map<K, V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return super.encode(input, ops, prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LenientSimpleMapCodec that = (LenientSimpleMapCodec)((Object)o);
        return Objects.equals(this.keyCodec, that.keyCodec) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.keyCodec, this.elementCodec);
    }

    public String toString() {
        return "SimpleMapCodec[" + this.keyCodec + " -> " + this.elementCodec + "]";
    }

    private static /* synthetic */ Map lambda$decode$5(Map elements, Unit unit) {
        return elements;
    }
}

