/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.biome.Biomes;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public class TBMultiNoiseBiomeSource
extends BiomeSource {
    public static final MapCodec<TBMultiNoiseBiomeSource> DIRECT_CODEC = RecordCodecBuilder.mapCodec(p_187070_ -> p_187070_.group((App)ExtraCodecs.m_144637_((Codec)RecordCodecBuilder.create(biomeMapping -> biomeMapping.group((App)TBClimate.ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.f_47431_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)biomeMapping, Pair::of)).listOf()).xmap(TBClimate.ParameterList::new, TBClimate.ParameterList::values).fieldOf("biomes").forGetter(p_187080_ -> p_187080_.parameters)).apply((Applicative)p_187070_, TBMultiNoiseBiomeSource::new));
    public static final Codec<TBMultiNoiseBiomeSource> CODEC = Codec.mapEither(PresetInstance.CODEC, DIRECT_CODEC).xmap(p_187068_ -> (TBMultiNoiseBiomeSource)((Object)((Object)p_187068_.map(PresetInstance::biomeSource, Function.identity()))), p_187066_ -> p_187066_.preset().map(Either::left).orElseGet(() -> Either.right((Object)p_187066_))).codec();
    private TBClimate.ParameterList<Supplier<Biome>> parameters;
    private final Optional<PresetInstance> preset;

    private TBMultiNoiseBiomeSource(TBClimate.ParameterList<Supplier<Biome>> p_187057_) {
        this(p_187057_, Optional.empty());
    }

    TBMultiNoiseBiomeSource(TBClimate.ParameterList<Supplier<Biome>> parameters, Optional<PresetInstance> p_187060_) {
        super(parameters.values().stream().map(Pair::getSecond));
        this.preset = p_187060_;
        this.parameters = parameters;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long p_48466_) {
        return this;
    }

    public Biome m_183546_(int p_186735_, int p_186736_, int p_186737_, Climate.Sampler sampler) {
        return this.getNoiseBiome(((TBClimate.Sampler)sampler).sampleTB(p_186735_, p_186736_, p_186737_));
    }

    private Optional<PresetInstance> preset() {
        return this.preset;
    }

    public boolean stable(Preset p_187064_) {
        return this.preset.isPresent() && Objects.equals(this.preset.get().preset(), p_187064_);
    }

    @VisibleForDebug
    public Biome getNoiseBiome(TBClimate.TargetPoint p_187062_) {
        return this.parameters.findValue(p_187062_, () -> Biomes.f_127322_).get();
    }

    public TBClimate.ParameterList<Supplier<Biome>> parameters() {
        return this.parameters;
    }

    record PresetInstance(Preset preset, Registry<Biome> biomes) {
        public static final MapCodec<PresetInstance> CODEC = RecordCodecBuilder.mapCodec(p_48558_ -> p_48558_.group((App)ResourceLocation.f_135803_.flatXmap(p_151869_ -> Optional.ofNullable(Preset.BY_NAME.get(p_151869_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + p_151869_))), p_151867_ -> DataResult.success((Object)p_151867_.name)).fieldOf("preset").stable().forGetter(PresetInstance::preset), (App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).forGetter(PresetInstance::biomes)).apply((Applicative)p_48558_, p_48558_.stable(PresetInstance::new)));

        public TBMultiNoiseBiomeSource biomeSource() {
            return this.preset.biomeSource(this, true);
        }
    }

    public static class Preset {
        static final Map<ResourceLocation, Preset> BY_NAME = Maps.newHashMap();
        public static final Preset OVERWORLD = new Preset(new ResourceLocation("terrablender", "overworld"), biomeRegistry -> Preset.createParameterSource((Registry<Biome>)biomeRegistry, BiomeProviderUtils::addAllOverworldBiomes));
        public static final Preset NETHER = new Preset(new ResourceLocation("terrablender", "nether"), biomeRegistry -> Preset.createParameterSource((Registry<Biome>)biomeRegistry, BiomeProviderUtils::addAllNetherBiomes));
        final ResourceLocation name;
        private final Function<Registry<Biome>, TBClimate.ParameterList<Supplier<Biome>>> parameterSource;

        public Preset(ResourceLocation name, Function<Registry<Biome>, TBClimate.ParameterList<Supplier<Biome>>> parameterSource) {
            this.name = name;
            this.parameterSource = parameterSource;
            BY_NAME.put(name, this);
        }

        public TBMultiNoiseBiomeSource biomeSource(PresetInstance preset, boolean isPreset) {
            return new TBMultiNoiseBiomeSource(this.buildParameters(preset), isPreset ? Optional.of(preset) : Optional.empty());
        }

        public TBMultiNoiseBiomeSource biomeSource(Registry<Biome> biomeRegistry, boolean isPreset) {
            return this.biomeSource(new PresetInstance(this, biomeRegistry), isPreset);
        }

        public TBMultiNoiseBiomeSource biomeSource(Registry<Biome> biomeRegistry) {
            return this.biomeSource(biomeRegistry, true);
        }

        private TBClimate.ParameterList<Supplier<Biome>> buildParameters(PresetInstance preset) {
            ImmutableList.Builder parameterListBuilder = ImmutableList.builder();
            parameterListBuilder.addAll(this.parameterSource.apply(preset.biomes()).values());
            return new TBClimate.ParameterList<Supplier<Biome>>((List<Pair<TBClimate.ParameterPoint, Supplier<Biome>>>)parameterListBuilder.build());
        }

        private static TBClimate.ParameterList<Supplier<Biome>> createParameterSource(Registry<Biome> biomeRegistry, BiConsumer<Registry<Biome>, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>>> addBiomes) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Consumer<Pair> mapper = parameterPair -> builder.add((Object)parameterPair.mapSecond(key -> () -> (Biome)biomeRegistry.m_123013_(key)));
            addBiomes.accept(biomeRegistry, mapper);
            return new TBClimate.ParameterList<Supplier<Biome>>((List<Pair<TBClimate.ParameterPoint, Supplier<Biome>>>)builder.build());
        }
    }
}

