/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import terrablender.worldgen.IExtendedNoiseBasedChunkGenerator;
import terrablender.worldgen.TBNoiseChunk;
import terrablender.worldgen.TBNoiseSampler;
import terrablender.worldgen.noise.LayeredNoiseUtil;

public class TBNoiseBasedChunkGenerator
extends NoiseBasedChunkGenerator
implements IExtendedNoiseBasedChunkGenerator {
    public static final Codec<TBNoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_194568_).forGetter(instance -> instance.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(instance -> instance.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(instance -> instance.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(instance -> instance.f_64318_)).apply((Applicative)builder, builder.stable(TBNoiseBasedChunkGenerator::new)));

    public TBNoiseBasedChunkGenerator(Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, long seed, Supplier<NoiseGeneratorSettings> settings) {
        this(noises, biomeSource, biomeSource, seed, settings);
    }

    private TBNoiseBasedChunkGenerator(Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, BiomeSource runtimeBiomeSource, long seed, Supplier<NoiseGeneratorSettings> settings) {
        super(noises, runtimeBiomeSource, seed, settings);
        LayeredNoiseUtil.UniquenessType uniquenessType;
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)this.f_64318_.get();
        NoiseSettings noiseSettings = noiseGeneratorSettings.m_64481_();
        boolean largeBiomes = noiseSettings.f_189185_();
        LayeredNoiseUtil.UniquenessType uniquenessType2 = uniquenessType = largeBiomes ? LayeredNoiseUtil.UniquenessType.OVERWORLD_LARGE : LayeredNoiseUtil.UniquenessType.OVERWORLD;
        if (noiseGeneratorSettings.m_64482_().m_60734_() == Blocks.f_50134_ && noiseGeneratorSettings.m_64483_().m_60734_() == Blocks.f_49991_) {
            uniquenessType = largeBiomes ? LayeredNoiseUtil.UniquenessType.NETHER_LARGE : LayeredNoiseUtil.UniquenessType.NETHER;
        }
        this.f_158382_ = new TBNoiseSampler(noiseSettings, noiseGeneratorSettings.m_158568_(), seed, noises, noiseGeneratorSettings.m_188893_(), uniquenessType);
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> registry, Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"init_biomes", () -> {
            this.doCreateBiomes(registry, blender, structureFeatureManager, chunkAccess);
            return chunkAccess;
        }), Util.m_183991_());
    }

    private void doCreateBiomes(Registry<Biome> biomeRegistry, Blender blender, StructureFeatureManager structureManager, ChunkAccess chunkAccess) {
        TBNoiseChunk noiseChunk = (TBNoiseChunk)this.getOrCreateNoiseChunk(chunkAccess, this.f_158382_, () -> new Beardifier(structureManager, chunkAccess), (NoiseGeneratorSettings)this.f_64318_.get(), this.f_188607_, blender);
        BiomeResolver biomeresolver = BelowZeroRetrogen.m_196981_((BiomeResolver)blender.m_183383_((BiomeResolver)this.f_62138_), biomeRegistry, (ChunkAccess)chunkAccess);
        chunkAccess.m_183442_(biomeresolver, (x, y, z) -> ((TBNoiseSampler)this.f_158382_).targetTB(x, y, z, noiseChunk.noiseDataTB(x, z)));
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new TBNoiseBasedChunkGenerator((Registry<NormalNoise.NoiseParameters>)this.f_188604_, this.f_62137_.m_7206_(seed), seed, this.f_64318_);
    }

    @Override
    public NoiseChunk forColumn(int x, int z, int cellNoiseMinY, int cellCountY, NoiseSampler sampler, NoiseGeneratorSettings noiseGenSettings, Aquifer.FluidPicker fluidPicker) {
        return TBNoiseChunk.forColumn(x, z, cellNoiseMinY, cellCountY, (TBNoiseSampler)sampler, noiseGenSettings, fluidPicker);
    }

    @Override
    public NoiseChunk getOrCreateNoiseChunk(ChunkAccess chunkAccess, NoiseSampler sampler, Supplier<NoiseChunk.NoiseFiller> noiseFiller, NoiseGeneratorSettings settings, Aquifer.FluidPicker fluidPicker, Blender blender) {
        if (chunkAccess.f_187605_ == null) {
            chunkAccess.f_187605_ = TBNoiseChunk.forChunk(chunkAccess, (TBNoiseSampler)sampler, noiseFiller, settings, fluidPicker, blender);
        }
        return chunkAccess.f_187605_;
    }
}

