/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;
import terrablender.worldgen.TBNoiseChunk;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.LayeredNoiseUtil;

public class TBNoiseSampler
extends NoiseSampler
implements TBClimate.Sampler {
    private final Area uniquenessNoise;
    private final List<TBClimate.ParameterPoint> tbSpawnTarget;

    public TBNoiseSampler(NoiseSettings noiseSettings, boolean isNoiseCavesEnabled, long seed, Registry<NormalNoise.NoiseParameters> noiseParamRegistry, WorldgenRandom.Algorithm randomSource, LayeredNoiseUtil.UniquenessType uniquenessType) {
        super(noiseSettings, isNoiseCavesEnabled, seed, noiseParamRegistry, randomSource);
        this.f_188940_ = instance -> instance.m_188780_((noiseX, noiseY, noiseZ) -> this.m_188990_(noiseX, noiseY, noiseZ, ((TBNoiseChunk)instance).noiseDataTB(QuartPos.m_175400_((int)noiseX), QuartPos.m_175400_((int)noiseZ)).terrainInfo(), instance.m_188743_()));
        this.uniquenessNoise = LayeredNoiseUtil.uniqueness(seed, uniquenessType);
        this.tbSpawnTarget = BiomeProviderUtils.getAllSpawnTargets();
        this.f_188925_ = null;
    }

    public NoiseSampler.FlatNoiseData m_189009_(int x, int z, Blender blender) {
        return null;
    }

    @Override
    public Climate.TargetPoint m_183445_(int x, int y, int z) {
        TBClimate.TargetPoint sample = this.sampleTB(x, y, z);
        return new Climate.TargetPoint(sample.temperature(), sample.humidity(), sample.continentalness(), sample.erosion(), sample.depth(), sample.weirdness());
    }

    public Climate.TargetPoint m_188976_(int x, int y, int z, NoiseSampler.FlatNoiseData noiseData) {
        throw new RuntimeException("Vanilla target called on TBNoiseSampler!");
    }

    @VisibleForDebug
    public TBFlatNoiseData noiseDataTB(int x, int z, Blender blender) {
        double shiftedX = (double)x + this.m_188972_(x, 0, z);
        double shiftedZ = (double)z + this.m_188972_(z, x, 0);
        double continentalness = this.m_188961_(shiftedX, 0.0, shiftedZ);
        double weirdness = this.m_189089_(shiftedX, 0.0, shiftedZ);
        double uniqueness = this.getUniqueness(shiftedX, 0.0, shiftedZ);
        double erosion = this.m_189075_(shiftedX, 0.0, shiftedZ);
        TerrainInfo terraininfo = this.m_188965_(QuartPos.m_175402_((int)x), QuartPos.m_175402_((int)z), (float)continentalness, (float)weirdness, (float)erosion, blender);
        return new TBFlatNoiseData(shiftedX, shiftedZ, continentalness, weirdness, uniqueness, erosion, terraininfo);
    }

    @Override
    public TBClimate.TargetPoint sampleTB(int x, int y, int z) {
        return this.targetTB(x, y, z, this.noiseDataTB(x, z, Blender.m_190153_()));
    }

    @VisibleForDebug
    public TBClimate.TargetPoint targetTB(int x, int y, int z, TBFlatNoiseData noiseData) {
        double d0 = noiseData.shiftedX();
        double d1 = (double)y + this.m_188972_(y, z, x);
        double d2 = noiseData.shiftedZ();
        double d3 = this.m_189013_(QuartPos.m_175402_((int)y), noiseData.terrainInfo());
        return TBClimate.target((float)this.m_189107_(d0, d1, d2), (float)this.m_189116_(d0, d1, d2), (float)noiseData.continentalness(), (float)noiseData.erosion(), (float)d3, (float)noiseData.weirdness(), (float)noiseData.uniqueness());
    }

    @Override
    public BlockPos m_183230_() {
        return TBClimate.findSpawnPosition(this.tbSpawnTarget, this);
    }

    @VisibleForDebug
    public double getUniqueness(double x, double y, double z) {
        return Climate.m_186796_((long)this.uniquenessNoise.get((int)x, (int)z));
    }

    public record TBFlatNoiseData(double shiftedX, double shiftedZ, double continentalness, double weirdness, double uniqueness, double erosion, TerrainInfo terrainInfo) {
    }
}

