/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit.data;

import io.github.noeppi_noeppi.libx.annotation.processor.modinit.FailureException;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModEnv;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModInit;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.data.DatagenEntry;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class DatagenProcessor {
    public static void processDatagen(Element element, ModEnv env) {
        List<DatagenEntry.Arg> args;
        Element element2;
        if (element.getKind() != ElementKind.CLASS || !(element instanceof TypeElement)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't use @Datagen on element that is not a class.", element);
            return;
        }
        if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE || !((element2 = element.getEnclosingElement()) instanceof PackageElement)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Parent of element annotated with @Datagen is not a package", element);
            return;
        }
        PackageElement parent = (PackageElement)element2;
        if (!env.subTypeErasure(element.asType(), env.forClass("net.minecraft.data.DataProvider"))) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "@Datagen can only be used on data providers.", element);
            return;
        }
        List<ExecutableElement> ctors = element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).toList();
        if (ctors.isEmpty()) {
            args = List.of();
        } else {
            if (ctors.size() != 1) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Class annotated with @Datagen can only have one public constructor.", element);
                return;
            }
            ExecutableElement ctor = ctors.get(0);
            args = ctor.getParameters().stream().map(p -> DatagenProcessor.getArg(p, env)).toList();
        }
        ModInit mod = env.getMod(element);
        mod.addDatagen(parent.getQualifiedName() + "." + element.getSimpleName(), args);
    }

    private static DatagenEntry.Arg getArg(VariableElement param, ModEnv env) {
        TypeMirror type = param.asType();
        if (env.subTypeErasure(type, env.forClass("io.github.noeppi_noeppi.libx.mod.ModX"))) {
            return DatagenEntry.Arg.MOD;
        }
        if (env.subTypeErasure(type, env.forClass("net.minecraft.data.DataGenerator"))) {
            return DatagenEntry.Arg.GENERATOR;
        }
        if (env.subTypeErasure(type, env.forClass("net.minecraftforge.common.data.ExistingFileHelper"))) {
            return DatagenEntry.Arg.FILE_HELPER;
        }
        env.messager().printMessage(Diagnostic.Kind.ERROR, "Constructor in datagen class may only have specific parameters..", param);
        throw new FailureException();
    }
}

