/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.base;

import io.github.noeppi_noeppi.libx.base.ItemBase;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemInventory<T extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends ItemBase {
    private final Function<Runnable, T> inventoryFactory;

    public ItemInventory(ModX mod, Item.Properties properties, Function<Runnable, T> inventoryFactory) {
        super(mod, properties);
        this.inventoryFactory = inventoryFactory;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag capTag) {
        final LazyOptional inventoryCapability = LazyOptional.of(() -> {
            AtomicReference<Object> handler = new AtomicReference<Object>(null);
            handler.set(((IItemHandlerModifiable)this.inventoryFactory.apply(() -> {
                CompoundTag nbt = stack.m_41784_();
                nbt.m_128365_("Inventory", ((INBTSerializable)((IItemHandlerModifiable)handler.get())).serializeNBT());
                stack.m_41751_(nbt);
            })));
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128425_("Inventory", 10)) {
                ((INBTSerializable)((IItemHandlerModifiable)handler.get())).deserializeNBT((Tag)nbt.m_128469_("Inventory"));
            }
            return handler.get();
        });
        return new ICapabilityProvider(){

            @Nonnull
            public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? inventoryCapability : LazyOptional.empty();
            }
        };
    }

    @Nullable
    public static IItemHandlerModifiable getInventory(ItemStack stack) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            return modifiable;
        }
        return null;
    }

    public static Stream<IItemHandlerModifiable> getInventoryStream(ItemStack stack) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            return Stream.of(modifiable);
        }
        return Stream.empty();
    }
}

