/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.base.decoration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.base.decoration.DecoratedBlock;
import io.github.noeppi_noeppi.libx.base.decoration.DecorationType;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class DecorationContext {
    public static final DecorationContext GENERIC = new DecorationContext("stone", DecorationType.BASE, DecorationType.SLAB, DecorationType.STAIR);
    public static final DecorationContext PLANKS = new DecorationContext("planks", DecorationType.BASE, DecorationType.SLAB, DecorationType.STAIR, DecorationType.FENCE, DecorationType.FENCE_GATE, DecorationType.WOOD_BUTTON, DecorationType.WOOD_PRESSURE_PLATE, DecorationType.DOOR, DecorationType.TRAPDOOR, DecorationType.SIGN);
    public static final DecorationContext STONE = new DecorationContext("stone", DecorationType.BASE, DecorationType.SLAB, DecorationType.STAIR, DecorationType.WALL, DecorationType.STONE_BUTTON, DecorationType.STONE_PRESSURE_PLATE);
    private final String name;
    private final Map<String, DecorationType<?>> types;
    private final Set<DecorationType<?>> typeSet;

    public DecorationContext(String name, DecorationType<?> ... types) {
        this.name = name;
        HashMap typeMap = new HashMap();
        for (DecorationType<?> type : types) {
            String typeName = type.name();
            if (typeName.isEmpty() && type != DecorationType.BASE) {
                throw new IllegalArgumentException("Only the base decoration type may have an empty name.");
            }
            if (typeMap.containsKey(typeName)) {
                throw new IllegalArgumentException("A decoration context can't have multiple types with the same name.");
            }
            typeMap.put(typeName, type);
        }
        if (!typeMap.containsKey("") || typeMap.get("") != DecorationType.BASE) {
            throw new IllegalArgumentException("Can't create decoration context without the base type.");
        }
        this.types = ImmutableMap.copyOf(typeMap);
        this.typeSet = ImmutableSet.copyOf(this.types.values());
    }

    public boolean has(DecorationType<?> type) {
        if (type == DecorationType.BASE) {
            return true;
        }
        String name = type.name();
        return this.types.containsKey(name) && this.types.get(name) == type;
    }

    public Set<DecorationType<?>> types() {
        return this.typeSet;
    }

    public RegistrationInfo register(ModX mod, DecoratedBlock block) {
        ImmutableMap.Builder elementMap = ImmutableMap.builder();
        ImmutableMap.Builder registerMap = ImmutableMap.builder();
        for (Map.Entry<String, DecorationType<?>> entry : this.types.entrySet()) {
            final Object element = entry.getValue().registration(mod, this, block);
            elementMap.put(entry.getValue(), element);
            if (entry.getKey().isEmpty()) continue;
            final Set<Object> additional = entry.getValue().additionalRegistration(mod, this, block, element);
            if (additional.isEmpty()) {
                registerMap.put((Object)entry.getKey(), element);
                continue;
            }
            registerMap.put((Object)entry.getKey(), (Object)new Registerable(){

                @Override
                public Set<Object> getAdditionalRegisters(ResourceLocation id) {
                    HashSet<Object> set = new HashSet<Object>(additional);
                    set.add(element);
                    return Collections.unmodifiableSet(set);
                }
            });
        }
        return new RegistrationInfo((Map<DecorationType<?>, Object>)elementMap.build(), (Map<String, Object>)registerMap.build());
    }

    public String toString() {
        return this.name + "[" + this.types.values().stream().map(DecorationType::name).filter(s -> !s.isEmpty()).sorted().collect(Collectors.joining(",")) + "]";
    }

    public record RegistrationInfo(Map<DecorationType<?>, Object> elementMap, Map<String, Object> registerMap) {
    }
}

