/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.noeppi_noeppi.libx.annotation.meta.Experimental;
import io.github.noeppi_noeppi.libx.codec.CodecHelper;
import io.github.noeppi_noeppi.libx.codec.TypedEncoder;
import io.github.noeppi_noeppi.libx.crafting.CraftingHelper2;
import io.github.noeppi_noeppi.libx.impl.codec.EnumCodec;
import io.github.noeppi_noeppi.libx.impl.codec.ErrorCodec;
import io.github.noeppi_noeppi.libx.impl.codec.ForgeRegistryCodec;
import io.github.noeppi_noeppi.libx.impl.codec.OptionCodec;
import io.github.noeppi_noeppi.libx.impl.codec.TypeMappedCodec;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Experimental
public class MoreCodecs {
    public static final Codec<Unit> UNIT = new Codec<Unit>(){

        public <T> DataResult<T> encode(Unit input, DynamicOps<T> ops, T prefix) {
            return DataResult.success(prefix);
        }

        public <T> DataResult<Pair<Unit, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)Unit.INSTANCE, input));
        }
    };
    public static final Codec<ItemStack> SAFE_ITEM_STACK = MoreCodecs.typeMapped(Codec.STRING.flatXmap(str -> CodecHelper.doesNotThrow(() -> ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)str))), stack -> CodecHelper.doesNotThrow(() -> stack.m_41739_(new CompoundTag()).toString())), TypedEncoder.of(Tag.class, stack -> stack.m_41739_(new CompoundTag()), tag -> ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))), TypedEncoder.of(JsonElement.class, stack -> CraftingHelper2.serializeItemStack(stack, true), json -> CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject(), (boolean)true)));

    public static <T> Codec<T> error(String msg) {
        return MoreCodecs.error(msg, msg);
    }

    public static <T> Codec<T> error(String encodeMsg, String decodeMsg) {
        return new ErrorCodec(encodeMsg, decodeMsg);
    }

    public static <T> Codec<Optional<T>> option(Codec<T> codec) {
        return new OptionCodec<T>(codec);
    }

    public static <T extends Enum<T>> Codec<T> enumCodec(Class<T> clazz) {
        return EnumCodec.get(clazz);
    }

    public static <T extends IForgeRegistryEntry<T>> Codec<T> registry(IForgeRegistry<T> registry) {
        return ForgeRegistryCodec.get(registry);
    }

    @SafeVarargs
    public static <T> Codec<T> typeMapped(TypedEncoder<T, ?> ... encoders) {
        if (encoders.length == 0) {
            return MoreCodecs.error("Empty type mapped codec");
        }
        ArrayList list = new ArrayList();
        for (TypedEncoder<T, ?> encoder : encoders) {
            list.add(encoder);
        }
        return new TypeMappedCodec(list, null);
    }

    @SafeVarargs
    public static <T> Codec<T> typeMapped(Codec<T> fallback, TypedEncoder<T, ?> ... encoders) {
        if (encoders.length == 0) {
            return fallback;
        }
        ArrayList list = new ArrayList();
        for (TypedEncoder<T, ?> encoder : encoders) {
            list.add(encoder);
        }
        return new TypeMappedCodec(list, fallback);
    }
}

