/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import javax.annotation.Nullable;

public class ClassUtil {
    private static final StackWalker STACK = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    public static Class<?> boxed(Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Void.TYPE.equals(clazz)) {
            return Void.class;
        }
        return clazz;
    }

    public static Class<?> unboxed(Class<?> clazz) {
        if (Boolean.class.equals(clazz)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(clazz)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(clazz)) {
            return Character.TYPE;
        }
        if (Short.class.equals(clazz)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(clazz)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(clazz)) {
            return Long.TYPE;
        }
        if (Float.class.equals(clazz)) {
            return Float.TYPE;
        }
        if (Double.class.equals(clazz)) {
            return Double.TYPE;
        }
        if (Void.class.equals(clazz)) {
            return Void.TYPE;
        }
        return clazz;
    }

    @Nullable
    public static Class<?> forName(String cls) {
        Class<?> caller = STACK.getCallerClass();
        try {
            return Class.forName(cls, true, caller.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }
}

