/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.tileentity.TileEntityDirectionBase;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;

public abstract class TileEntityPlatformBase
extends TileEntityDirectionBase {
    private ItemStack itemBaseFrame = ItemStack.f_41583_;
    private ItemStack itemBaseCover = ItemStack.f_41583_;
    private ItemStack itemRail = ItemStack.f_41583_;
    private ItemStack itemLayerTexture = ItemStack.f_41583_;
    private ItemStack itemRailFrame = ItemStack.f_41583_;
    private ItemStack itemRailCover = ItemStack.f_41583_;
    private SoundType soundBase = null;
    private SoundType soundRail = null;
    private final boolean[] isColorCached = new boolean[4];
    private final int[] materialColor = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};

    public TileEntityPlatformBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected boolean isDirectionValid(Direction facing) {
        return facing != null && facing.m_122434_() != Direction.Axis.Y;
    }

    protected void buildNBT(CompoundTag nbtTag) {
        CompoundTag stack;
        if (!this.itemBaseFrame.m_41619_()) {
            stack = new CompoundTag();
            this.itemBaseFrame.m_41739_(stack);
            nbtTag.m_128365_("frame_texture_item", (Tag)stack);
        }
        if (!this.itemBaseCover.m_41619_()) {
            stack = new CompoundTag();
            this.itemBaseCover.m_41739_(stack);
            nbtTag.m_128365_("cover_texture_item", (Tag)stack);
        }
        if (!this.itemRail.m_41619_()) {
            stack = new CompoundTag();
            this.itemRail.m_41739_(stack);
            nbtTag.m_128365_("rail_item", (Tag)stack);
        }
        if (!this.itemLayerTexture.m_41619_()) {
            stack = new CompoundTag();
            this.itemLayerTexture.m_41739_(stack);
            nbtTag.m_128365_("layer_texture_item", (Tag)stack);
        }
    }

    protected void processNBT(CompoundTag nbtTag) {
        if (nbtTag.m_128441_("frame_texture_item")) {
            this.itemBaseFrame = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("frame_texture_item"));
        }
        if (nbtTag.m_128441_("cover_texture_item")) {
            this.itemBaseCover = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("cover_texture_item"));
        }
        if (nbtTag.m_128441_("rail_item")) {
            this.setRailItem(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("rail_item")));
        }
        if (nbtTag.m_128441_("layer_texture_item")) {
            this.setLevelTexture(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("layer_texture_item")));
        }
        this.requestModelDataUpdate();
    }

    public void setTextureInfo(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform) {
            this.setFrameTextureBlock(ItemBlockPlatform.getFrameTextureStack(stack));
            this.setCoverTextureBlock(ItemBlockPlatform.getCoverTextureStack(stack));
        }
    }

    public void setFrameTextureBlock(ItemStack stack) {
        this.itemBaseFrame = stack;
    }

    public ItemStack getFrameTextureBlock() {
        return this.itemBaseFrame;
    }

    public void setCoverTextureBlock(ItemStack stack) {
        this.itemBaseCover = stack;
    }

    public ItemStack getCoverTextureBlock() {
        return this.itemBaseCover;
    }

    public ItemStack getRailFrameTextureBlock() {
        return this.itemRailFrame;
    }

    public ItemStack getRailCoverTextureBlock() {
        return this.itemRailCover;
    }

    public SoundType getSoundType() {
        if (this.soundBase == null) {
            this.soundBase = this.merge(this.getSoundType(this.itemBaseFrame), this.getSoundType(this.itemBaseCover));
        }
        return this.soundBase;
    }

    public SoundType getRailSound() {
        if (this.soundRail == null) {
            this.soundRail = this.merge(this.getSoundType(this.itemRailFrame), this.getSoundType(this.itemRailCover));
        }
        return this.soundRail;
    }

    private SoundType getSoundType(ItemStack stack) {
        SoundType soundType = null;
        if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem) {
            BlockState state = UseContext.getBlockPlacementStateFor((ItemStack)stack, (Level)this.f_58857_);
            try {
                soundType = ((BlockItem)stack.m_41720_()).m_40614_().getSoundType(state, (LevelReader)this.m_58904_(), this.m_58899_(), null);
            }
            catch (Exception ignored) {
                soundType = ((BlockItem)stack.m_41720_()).m_40614_().m_49962_(state);
            }
        }
        return soundType;
    }

    private SoundType merge(SoundType frame, SoundType cover) {
        if (frame == cover) {
            return frame != null ? frame : SoundType.f_56736_;
        }
        frame = frame != null ? frame : SoundType.f_56736_;
        cover = cover != null ? cover : SoundType.f_56736_;
        return new SoundType(1.0f, 1.0f, frame.m_56775_(), cover.m_56776_(), frame.m_56777_(), frame.m_56778_(), cover.m_56779_());
    }

    public boolean hasRail() {
        return !this.itemRail.m_41619_();
    }

    public void removeRail() {
        this.itemRail = ItemStack.f_41583_;
        this.itemRailFrame = ItemStack.f_41583_;
        this.itemRailCover = ItemStack.f_41583_;
        this.isColorCached[2] = false;
        this.isColorCached[3] = false;
        this.materialColor[2] = 0xFFFFFF;
        this.materialColor[3] = 0xFFFFFF;
    }

    public boolean setRailItem(ItemStack stack) {
        ItemBlockPlatform platform;
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)stack.m_41720_()).getPlatformType().isAddon()) {
            this.itemRail = stack.m_41777_().m_41620_(1);
            this.itemRailFrame = ItemBlockPlatform.getFrameTextureStack(stack);
            this.itemRailCover = ItemBlockPlatform.getCoverTextureStack(stack);
            return true;
        }
        return false;
    }

    public ItemStack getRailItem() {
        return this.itemRail;
    }

    public EnumPlatformType getRailType() {
        if (this.hasRail()) {
            ItemBlockPlatform platform;
            if (!this.itemRail.m_41619_() && this.itemRail.m_41720_() instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)this.itemRail.m_41720_()).getPlatformType().isAddon()) {
                return platform.getPlatformType();
            }
            this.removeRail();
        }
        return null;
    }

    public void resetLevelTexture() {
        this.itemLayerTexture = ItemStack.f_41583_;
        this.requestModelDataUpdate();
    }

    public boolean setLevelTexture(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem && this.setLevelTexture(((BlockItem)stack.m_41720_()).m_40614_())) {
            this.requestModelDataUpdate();
            return true;
        }
        return false;
    }

    private boolean setLevelTexture(Block block) {
        if (block == Blocks.f_50127_ || block instanceof SnowLayerBlock || block instanceof FallingBlock && block.m_49966_().m_60767_() == Material.f_76317_) {
            this.itemLayerTexture = new ItemStack((ItemLike)block);
            return true;
        }
        return false;
    }

    public void playLevelTextureSound(Player player, boolean place) {
        if (this.m_58904_() != null && !this.itemLayerTexture.m_41619_() && player != null) {
            if (this.itemLayerTexture.m_41720_() instanceof BlockItem) {
                Block block = ((BlockItem)this.itemLayerTexture.m_41720_()).m_40614_();
                if (place) {
                    this.m_58904_().m_5594_(player, this.m_58899_(), block.m_49962_(block.m_49966_()).m_56777_(), SoundSource.BLOCKS, 1.0f, this.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
                } else {
                    this.m_58904_().m_5594_(player, this.m_58899_(), block.m_49962_(block.m_49966_()).m_56775_(), SoundSource.BLOCKS, 1.0f, this.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
                }
            } else {
                this.resetLevelTexture();
            }
        }
    }

    public Block getLayerTextureBlock() {
        if (!this.itemLayerTexture.m_41619_() && this.itemLayerTexture.m_41720_() instanceof BlockItem) {
            return ((BlockItem)this.itemLayerTexture.m_41720_()).m_40614_();
        }
        this.resetLevelTexture();
        return Blocks.f_50016_;
    }

    public Block getBiomeLayerTexture(Biome biome) {
        return biome.m_47530_() == Biome.Precipitation.SNOW || biome.m_198904_(this.m_58899_()) ? Blocks.f_50127_ : BlockPlatformBase.getBiomeTopBlock(biome);
    }

    public void addExtraDrops(List<ItemStack> drops) {
        if (this.hasRail()) {
            drops.add(this.itemRail);
        }
    }

    public int getTint(int index) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (index >= 0 && index < 4 && !this.isColorCached[index]) {
                ItemStack material;
                ItemStack itemStack = index == 3 ? this.itemRailCover : (index == 2 ? this.itemRailFrame : (material = index == 1 ? this.itemBaseCover : this.itemBaseFrame));
                if (!material.m_41619_()) {
                    this.materialColor[index] = Minecraft.m_91087_().m_91298_().m_92577_(UseContext.getBlockPlacementStateFor((ItemStack)material, (Level)this.m_58904_()), (BlockAndTintGetter)this.m_58904_(), this.m_58899_(), 0);
                    this.isColorCached[index] = true;
                }
            }
        });
        return index >= 0 && index < 4 ? this.materialColor[index] : 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_((double)0.55f, (double)0.55f, (double)0.55f);
    }

    public IModelData getModelData() {
        CompoundTag nbtTag = new CompoundTag();
        if (this.itemLayerTexture.m_41619_() && this.m_58904_() != null) {
            this.setLevelTexture(this.getBiomeLayerTexture(this.m_58904_().m_46857_(this.m_58899_())));
        }
        this.buildNBT(nbtTag);
        return new ModelDataMap.Builder().withInitial(ModelProperties.NBTProperty, (Object)nbtTag).build();
    }
}

