/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileUnpackager;
import thelm.packagedexcrafting.client.gui.GuiCombinationCrafter;
import thelm.packagedexcrafting.container.ContainerCombinationCrafter;
import thelm.packagedexcrafting.integration.appeng.networking.HostHelperTileCombinationCrafter;
import thelm.packagedexcrafting.inventory.InventoryCombinationCrafter;
import thelm.packagedexcrafting.recipe.IRecipeInfoCombination;
import thelm.packagedexcrafting.tile.TileMarkedPedestal;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileCombinationCrafter
extends TileBase
implements ITickable,
IPackageCraftingMachine,
IGridHost,
IActionHost {
    public static boolean enabled = true;
    public static int energyCapacity = 5000000;
    public static boolean drawMEEnergy = false;
    public int requiredPedestals = 0;
    public boolean isWorking = false;
    public long energyReq = 0L;
    public long remainingProgress = 0L;
    public int energyUsage = 0;
    public IRecipeInfoCombination currentRecipe;
    public List<BlockPos> pedestals = new ArrayList<BlockPos>();
    public HostHelperTileCombinationCrafter hostHelper;

    public TileCombinationCrafter() {
        this.setInventory(new InventoryCombinationCrafter(this));
        this.setEnergyStorage(new EnergyStorage((TileBase)this, energyCapacity));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileCombinationCrafter(this);
        }
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedexcrafting.combination_crafter.name");
    }

    public ITextComponent getMessage() {
        if (this.isWorking) {
            return null;
        }
        int usablePedestals = this.getEmptyPedestals().size();
        TextComponentTranslation message = new TextComponentTranslation("tile.packagedexcrafting.combination_crafter.pedestals.usable", new Object[]{usablePedestals});
        if (this.requiredPedestals > 0) {
            message.func_150258_a("\n");
            message.func_150257_a((ITextComponent)new TextComponentTranslation("tile.packagedexcrafting.combination_crafter.pedestals.required", new Object[]{this.requiredPedestals}));
        }
        return message;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0L) {
                    this.finishProcess();
                    if (this.hostHelper != null && this.hostHelper.isActive()) {
                        this.hostHelper.ejectItem();
                    } else {
                        this.ejectItems();
                    }
                }
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                if (this.hostHelper != null && this.hostHelper.isActive()) {
                    this.hostHelper.ejectItem();
                    if (drawMEEnergy) {
                        this.hostHelper.chargeEnergy();
                    }
                } else {
                    this.ejectItems();
                }
            }
            this.energyStorage.updateIfChanged();
        }
    }

    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
        if (!this.isBusy() && recipeInfo instanceof IRecipeInfoCombination) {
            IRecipeInfoCombination recipe = (IRecipeInfoCombination)recipeInfo;
            List<ItemStack> pedestalInputs = recipe.getPedestalInputs();
            List<BlockPos> emptyPedestals = this.getEmptyPedestals();
            this.requiredPedestals = Math.max(this.requiredPedestals, pedestalInputs.size());
            if (emptyPedestals.size() >= pedestalInputs.size()) {
                this.pedestals.clear();
                this.pedestals.addAll(emptyPedestals.subList(0, pedestalInputs.size()));
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.energyReq = this.remainingProgress = recipe.getEnergyRequired();
                this.energyUsage = recipe.getEnergyUsage();
                this.inventory.func_70299_a(0, recipe.getCoreInput());
                for (int i = 0; i < this.pedestals.size(); ++i) {
                    ((TileMarkedPedestal)this.field_145850_b.func_175625_s(this.pedestals.get(i))).getInventory().func_70299_a(0, pedestalInputs.get(i).func_77946_l());
                }
                this.syncTile(false);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.inventory.stacks.subList(0, 2).stream().allMatch(ItemStack::func_190926_b);
    }

    protected void tickProcess() {
        if (this.pedestals.stream().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).anyMatch(tile -> !(tile instanceof TileMarkedPedestal) || tile.func_145837_r())) {
            this.endProcess();
        } else {
            int energy = this.energyStorage.extractEnergy((int)Math.min((long)this.energyUsage, this.remainingProgress), false);
            this.remainingProgress -= (long)energy;
            if (!this.field_145850_b.field_72995_K) {
                ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.SPELL, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.1, new int[0]);
            }
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.pedestals.stream().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).anyMatch(tile -> !(tile instanceof TileMarkedPedestal) || tile.func_145837_r())) {
            this.endProcess();
            return;
        }
        for (BlockPos pedestalPos : this.pedestals) {
            InventoryTileBase pedestalInv = ((TileMarkedPedestal)this.field_145850_b.func_175625_s(pedestalPos)).getInventory();
            pedestalInv.func_70299_a(0, MiscUtil.getContainerItem((ItemStack)pedestalInv.func_70301_a(0)));
            ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.SMOKE_NORMAL, false, (double)pedestalPos.func_177958_n() + 0.5, (double)pedestalPos.func_177956_o() + 1.1, (double)pedestalPos.func_177952_p() + 0.5, 20, 0.0, 0.0, 0.0, 0.1, new int[0]);
        }
        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.END_ROD, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 50, 0.0, 0.0, 0.0, 0.1, new int[0]);
        this.inventory.func_70299_a(1, this.currentRecipe.getOutput());
        this.endProcess();
    }

    public void endProcess() {
        this.energyReq = 0L;
        this.remainingProgress = 0L;
        this.energyUsage = 0;
        this.pedestals.stream().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(tile -> tile instanceof TileMarkedPedestal && !tile.func_145837_r()).forEach(tile -> ((TileMarkedPedestal)((Object)tile)).spawnItem());
        this.pedestals.clear();
        this.isWorking = false;
        this.currentRecipe = null;
        this.syncTile(false);
        this.func_70296_d();
    }

    protected List<BlockPos> getEmptyPedestals() {
        return Streams.stream((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-3, 0, -3), (BlockPos)this.field_174879_c.func_177982_a(3, 0, 3))).filter(pos -> {
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile instanceof TileMarkedPedestal) {
                return ((TileMarkedPedestal)tile).getInventory().func_191420_l();
            }
            return false;
        }).collect(Collectors.toList());
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 1 : 0;
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile instanceof TileUnpackager || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            boolean flag = true;
            for (int i = 1; i >= endIndex; --i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack stackRem = itemHandler.insertItem(slot, stack, false);
                    if (stackRem.func_190916_E() < stack.func_190916_E()) {
                        stack = stackRem;
                        flag = false;
                    }
                    if (stack.func_190926_b()) break;
                }
                this.inventory.func_70299_a(i, stack);
                if (flag) continue block0;
            }
        }
    }

    protected void chargeEnergy() {
        int prevStored = this.energyStorage.getEnergyStored();
        ItemStack energyStack = this.inventory.func_70301_a(2);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(2, ItemStack.field_190927_a);
            }
        }
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.inventory.stacks.subList(0, 2).stream().allMatch(ItemStack::func_190926_b)) {
            return 15;
        }
        return 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentRecipe = null;
        if (nbt.func_74764_b("Recipe")) {
            NBTTagCompound tag = nbt.func_74775_l("Recipe");
            IRecipeInfo recipe = MiscUtil.readRecipeFromNBT((NBTTagCompound)tag);
            if (recipe instanceof IRecipeInfoCombination) {
                this.currentRecipe = (IRecipeInfoCombination)recipe;
            }
            this.pedestals.clear();
            NBTTagList pedestalsTag = nbt.func_150295_c("Pedestals", 11);
            for (int i = 0; i < pedestalsTag.func_74745_c(); ++i) {
                int[] posArray = pedestalsTag.func_150306_c(i);
                BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                this.pedestals.add(pos);
            }
        }
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
    }

    /*
     * Exception decompiling
     */
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.remainingProgress = nbt.func_74763_f("Progress");
        this.energyReq = nbt.func_74763_f("EnergyReq");
        this.energyUsage = nbt.func_74762_e("EnergyUsage");
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74772_a("Progress", this.remainingProgress);
        nbt.func_74772_a("EnergyReq", this.energyReq);
        nbt.func_74768_a("EnergyUsage", this.energyUsage);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0L || this.energyReq == 0L) {
            return 0;
        }
        return (int)((long)scale * (this.energyReq - this.remainingProgress) / this.energyReq);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiCombinationCrafter(new ContainerCombinationCrafter(player.field_71071_by, this));
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerCombinationCrafter(player.field_71071_by, this);
    }

    private static /* synthetic */ void lambda$writeToNBT$6(NBTTagList pedestalsTag, int[] arr) {
        pedestalsTag.func_74742_a((NBTBase)new NBTTagIntArray(arr));
    }
}

