/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.blakebr0.extendedcrafting.block.BlockEnderAlternator;
import com.google.common.collect.Streams;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileUnpackager;
import thelm.packagedexcrafting.client.gui.GuiEnderCrafter;
import thelm.packagedexcrafting.container.ContainerEnderCrafter;
import thelm.packagedexcrafting.integration.appeng.networking.HostHelperTileEnderCrafter;
import thelm.packagedexcrafting.inventory.InventoryEnderCrafter;
import thelm.packagedexcrafting.recipe.IRecipeInfoEnder;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileEnderCrafter
extends TileBase
implements ITickable,
IPackageCraftingMachine,
IGridHost,
IActionHost {
    public static boolean enabled = true;
    public static int energyCapacity = 5000;
    public static int progressReq = 600;
    public static double alternatorEff = 0.02;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int progress = 0;
    public int actualProgressReq = 0;
    public int remainingProgress = 0;
    public IRecipeInfoEnder currentRecipe;
    public HostHelperTileEnderCrafter hostHelper;

    public TileEnderCrafter() {
        this.setInventory(new InventoryEnderCrafter(this));
        this.setEnergyStorage(new EnergyStorage((TileBase)this, energyCapacity));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileEnderCrafter(this);
        }
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedexcrafting.ender_crafter.name");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    if (this.hostHelper != null && this.hostHelper.isActive()) {
                        this.hostHelper.ejectItem();
                    } else {
                        this.ejectItems();
                    }
                }
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                if (this.hostHelper != null && this.hostHelper.isActive()) {
                    this.hostHelper.ejectItem();
                    if (drawMEEnergy) {
                        this.hostHelper.chargeEnergy();
                    }
                } else {
                    this.ejectItems();
                }
            }
            this.energyStorage.updateIfChanged();
        }
    }

    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
        if (!this.isBusy() && recipeInfo instanceof IRecipeInfoEnder) {
            IRecipeInfoEnder recipe = (IRecipeInfoEnder)recipeInfo;
            ItemStack slotStack = this.inventory.func_70301_a(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.func_190926_b() || slotStack.func_77973_b() == outputStack.func_77973_b() && slotStack.func_77952_i() == outputStack.func_77952_i() && ItemStack.areItemStackShareTagsEqual((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d()) {
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.remainingProgress = energyReq;
                for (int i = 0; i < 9; ++i) {
                    this.inventory.func_70299_a(i, recipe.getMatrix().func_70301_a(i).func_77946_l());
                }
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.inventory.stacks.subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    protected void tickProcess() {
        int alternatorCount = this.getAlternatorCount();
        if (alternatorCount > 0) {
            ++this.progress;
            this.actualProgressReq = (int)Math.max((double)progressReq * (1.0 - alternatorEff * (double)alternatorCount), 0.0);
        }
        if (this.progress >= this.actualProgressReq) {
            this.progress = this.actualProgressReq;
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.inventory.func_70301_a(9).func_190926_b()) {
            this.inventory.func_70299_a(9, this.currentRecipe.getOutput());
        } else {
            this.inventory.func_70301_a(9).func_190917_f(this.currentRecipe.getOutput().func_190916_E());
        }
        for (int i = 0; i < 9; ++i) {
            this.inventory.func_70299_a(i, MiscUtil.getContainerItem((ItemStack)this.inventory.func_70301_a(i)));
        }
        this.endProcess();
    }

    public void endProcess() {
        this.progress = 0;
        this.remainingProgress = 0;
        this.isWorking = false;
        this.currentRecipe = null;
        this.func_70296_d();
    }

    protected int getAlternatorCount() {
        return (int)Streams.stream((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-3, -3, -3), (BlockPos)this.field_174879_c.func_177982_a(3, 3, 3))).map(pos -> this.field_145850_b.func_180495_p(pos).func_177230_c()).filter(block -> block instanceof BlockEnderAlternator).count();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile instanceof TileUnpackager || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            boolean flag = true;
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack stackRem = itemHandler.insertItem(slot, stack, false);
                    if (stackRem.func_190916_E() < stack.func_190916_E()) {
                        stack = stackRem;
                        flag = false;
                    }
                    if (stack.func_190926_b()) break;
                }
                this.inventory.func_70299_a(i, stack);
                if (flag) continue block0;
            }
        }
    }

    protected void chargeEnergy() {
        int prevStored = this.energyStorage.getEnergyStored();
        ItemStack energyStack = this.inventory.func_70301_a(10);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(10, ItemStack.field_190927_a);
            }
        }
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.inventory.stacks.subList(0, 10).stream().allMatch(ItemStack::func_190926_b)) {
            return 15;
        }
        return 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        IRecipeInfo recipe;
        super.func_145839_a(nbt);
        this.currentRecipe = null;
        if (nbt.func_74764_b("Recipe") && (recipe = MiscUtil.readRecipeFromNBT((NBTTagCompound)(tag = nbt.func_74775_l("Recipe")))) instanceof IRecipeInfoEnder) {
            this.currentRecipe = (IRecipeInfoEnder)recipe;
        }
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.currentRecipe != null) {
            NBTTagCompound tag = MiscUtil.writeRecipeToNBT((NBTTagCompound)new NBTTagCompound(), (IRecipeInfo)this.currentRecipe);
            nbt.func_74782_a("Recipe", (NBTBase)tag);
        }
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.progress = nbt.func_74762_e("Progress");
        this.remainingProgress = nbt.func_74762_e("EnergyProgress");
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("EnergyProgress", this.remainingProgress);
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0) {
            return 0;
        }
        return scale * this.progress / this.actualProgressReq;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiEnderCrafter(new ContainerEnderCrafter(player.field_71071_by, this));
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerEnderCrafter(player.field_71071_by, this);
    }
}

