/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.hook;

import java.util.function.Predicate;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class EntityLivingBaseHook {
    private EntityLivingBaseHook() {
    }

    public static void dismountEntity(EntityLivingBase rider, Entity riding) {
        if (!riding.field_70128_L && rider.field_70170_p.func_180495_p(riding.func_180425_c()).func_185904_a() != Material.field_151567_E) {
            Vec3d pos = EntityLivingBaseHook.getDismountPosition(rider, riding);
            rider.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        } else {
            rider.func_70634_a(riding.field_70165_t, riding.field_70163_u + (double)riding.field_70131_O, riding.field_70161_v);
        }
    }

    public static Vec3d getDismountPosition(Entity riding) {
        return new Vec3d(riding.field_70165_t, riding.func_174813_aQ().field_72337_e, riding.field_70161_v);
    }

    public static Vec3d getDismountPosition(EntityLivingBase rider, Entity riding) {
        if (riding instanceof EntityBoat) {
            return EntityLivingBaseHook.getDismountPosition(rider, (EntityBoat)riding);
        }
        if (riding instanceof EntityMinecart) {
            return EntityLivingBaseHook.getDismountPosition(rider, (EntityMinecart)riding);
        }
        if (riding instanceof EntityPig) {
            return EntityLivingBaseHook.getDismountPosition(rider, (EntityPig)riding);
        }
        return EntityLivingBaseHook.getDismountPosition(riding);
    }

    public static Vec3d getDismountPosition(EntityLivingBase rider, EntityBoat boat) {
        Vec3d dismountPos;
        Vec3d xzDisplacement = EntityLivingBaseHook.getXZDisplacement(boat.field_70130_N * MathHelper.field_180189_a, rider.field_70130_N, boat.field_70177_z);
        double x = boat.field_70165_t + xzDisplacement.field_72450_a;
        double z = boat.field_70161_v + xzDisplacement.field_72449_c;
        BlockPos pos = new BlockPos(x, boat.func_174813_aQ().field_72337_e, z);
        double yDisplacement = EntityLivingBaseHook.getYDisplacement(boat.field_70170_p, pos);
        if (EntityLivingBaseHook.isValidYDisplacement(yDisplacement)) {
            dismountPos = new Vec3d(x, (double)pos.func_177956_o() + yDisplacement, z);
            if (!rider.field_70170_p.func_72829_c(rider.func_174813_aQ().func_191194_a(dismountPos))) {
                return dismountPos;
            }
        }
        if (EntityLivingBaseHook.isValidYDisplacement(yDisplacement = EntityLivingBaseHook.getYDisplacement(boat.field_70170_p, pos = pos.func_177977_b()))) {
            dismountPos = new Vec3d(x, (double)pos.func_177956_o() + yDisplacement, z);
            if (!rider.field_70170_p.func_72829_c(rider.func_174813_aQ().func_191194_a(dismountPos))) {
                return dismountPos;
            }
        }
        return EntityLivingBaseHook.getDismountPosition((Entity)boat);
    }

    public static Vec3d getDismountPosition(EntityLivingBase rider, EntityMinecart minecart) {
        EnumFacing facing = minecart.func_184172_bi();
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return EntityLivingBaseHook.getDismountPosition((Entity)minecart);
        }
        int[][] offsets = EntityLivingBaseHook.getOffsets(facing);
        BlockPos pos = minecart.func_180425_c();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = -1; i < 2; ++i) {
            for (int[] offset : offsets) {
                mutable.func_181079_c(pos.func_177958_n() + offset[0], pos.func_177956_o() + i, pos.func_177952_p() + offset[1]);
                double yDisplacement = EntityLivingBaseHook.getYDisplacement(minecart.field_70170_p, (BlockPos)mutable, state -> {
                    if (state.func_177230_c().isLadder(state, (IBlockAccess)minecart.field_70170_p, pos, rider)) {
                        return true;
                    }
                    return state.func_177230_c() instanceof BlockTrapDoor && (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) != false;
                });
                if (!EntityLivingBaseHook.isValidYDisplacement(yDisplacement)) continue;
                Vec3d dismountPos = new Vec3d((double)mutable.func_177958_n() + 0.5, (double)mutable.func_177956_o() + yDisplacement, (double)mutable.func_177952_p() + 0.5);
                if (rider.field_70170_p.func_72829_c(rider.func_174813_aQ().func_191194_a(dismountPos))) continue;
                return dismountPos;
            }
        }
        return EntityLivingBaseHook.getDismountPosition((Entity)minecart);
    }

    public static Vec3d getDismountPosition(EntityLivingBase rider, EntityPig pig) {
        EnumFacing facing = pig.func_184172_bi();
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return EntityLivingBaseHook.getDismountPosition((Entity)pig);
        }
        int[][] offsets = EntityLivingBaseHook.getOffsets(facing);
        BlockPos pos = pig.func_180425_c();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int[] offset : offsets) {
            mutable.func_181079_c(pos.func_177958_n() + offset[0], pos.func_177956_o(), pos.func_177952_p() + offset[1]);
            double yDisplacement = EntityLivingBaseHook.getYDisplacement(pig.field_70170_p, (BlockPos)mutable);
            if (!EntityLivingBaseHook.isValidYDisplacement(yDisplacement)) continue;
            Vec3d dismountPos = new Vec3d((double)mutable.func_177958_n() + 0.5, (double)mutable.func_177956_o() + yDisplacement, (double)mutable.func_177952_p() + 0.5);
            if (rider.field_70170_p.func_72829_c(rider.func_174813_aQ().func_191194_a(dismountPos))) continue;
            return dismountPos;
        }
        return EntityLivingBaseHook.getDismountPosition((Entity)pig);
    }

    public static Vec3d getXZDisplacement(double ridingWidth, double riderWidth, float ridingYaw) {
        double averageWidth = (ridingWidth + riderWidth) / 2.0;
        float sin = -MathHelper.func_76126_a((float)((float)((double)ridingYaw * Math.PI / 180.0)));
        float cos = MathHelper.func_76134_b((float)((float)((double)ridingYaw * Math.PI / 180.0)));
        float max = Math.max(Math.abs(sin), Math.abs(cos));
        return new Vec3d((double)sin * averageWidth / (double)max, 0.0, (double)cos * averageWidth / (double)max);
    }

    public static double getYDisplacement(World world, BlockPos pos) {
        return EntityLivingBaseHook.getYDisplacement(world, pos, state -> false);
    }

    public static double getYDisplacement(World world, BlockPos pos, Predicate<IBlockState> ignore) {
        AxisAlignedBB collisionBox;
        IBlockState state = world.func_180495_p(pos);
        AxisAlignedBB axisAlignedBB = collisionBox = ignore.test(state) ? null : state.func_185890_d((IBlockAccess)world, pos);
        if (collisionBox != null && collisionBox.field_72337_e != 0.0) {
            return collisionBox.field_72337_e;
        }
        state = world.func_180495_p(pos = pos.func_177977_b());
        collisionBox = ignore.test(state) ? null : state.func_185890_d((IBlockAccess)world, pos);
        double maxY = collisionBox == null ? 0.0 : collisionBox.field_72337_e;
        return maxY >= 1.0 ? maxY - 1.0 : Double.NEGATIVE_INFINITY;
    }

    public static boolean isValidYDisplacement(double displacement) {
        return !Double.isInfinite(displacement) && displacement < 1.0;
    }

    public static int[][] getOffsets(EnumFacing facing) {
        EnumFacing direction1 = facing.func_176746_e();
        EnumFacing direction2 = direction1.func_176734_d();
        EnumFacing direction3 = facing.func_176734_d();
        return new int[][]{{direction1.func_82601_c(), direction1.func_82599_e()}, {direction2.func_82601_c(), direction2.func_82599_e()}, {direction3.func_82601_c() + direction1.func_82601_c(), direction3.func_82599_e() + direction1.func_82599_e()}, {direction3.func_82601_c() + direction2.func_82601_c(), direction3.func_82599_e() + direction2.func_82599_e()}, {facing.func_82601_c() + direction1.func_82601_c(), facing.func_82599_e() + direction1.func_82599_e()}, {facing.func_82601_c() + direction2.func_82601_c(), facing.func_82599_e() + direction2.func_82599_e()}, {direction3.func_82601_c(), direction3.func_82599_e()}, {facing.func_82601_c(), facing.func_82599_e()}};
    }
}

