/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block;

import codechicken.lib.vec.Vector3;
import gregtech.api.GregTechAPI;
import gregtech.api.block.ICustomParticleBlock;
import gregtech.api.network.IPacket;
import gregtech.api.util.ParticleHandlerUtil;
import gregtech.core.network.NetworkUtils;
import gregtech.core.network.packets.PacketBlockParticle;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BlockCustomParticle
extends Block
implements ICustomParticleBlock {
    public BlockCustomParticle(Material blockMaterialIn, MapColor blockMapColorIn) {
        super(blockMaterialIn, blockMapColorIn);
    }

    public BlockCustomParticle(Material materialIn) {
        super(materialIn);
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract Pair<TextureAtlasSprite, Integer> getParticleTexture(World var1, BlockPos var2);

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World worldObj, RayTraceResult target, @Nonnull ParticleManager manager) {
        Pair<TextureAtlasSprite, Integer> atlasSprite = this.getParticleTexture(worldObj, target.func_178782_a());
        ParticleHandlerUtil.addHitEffects(state, worldObj, target, (TextureAtlasSprite)atlasSprite.getLeft(), (Integer)atlasSprite.getRight(), manager);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager manager) {
        Pair<TextureAtlasSprite, Integer> atlasSprite = this.getParticleTexture(world, pos);
        ParticleHandlerUtil.addBlockDestroyEffects(world.func_180495_p(pos), world, pos, (TextureAtlasSprite)atlasSprite.getLeft(), (Integer)atlasSprite.getRight(), manager);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleCustomParticle(World worldObj, BlockPos blockPos, ParticleManager particleManager, Vector3 entityPos, int numberOfParticles) {
        Pair<TextureAtlasSprite, Integer> atlasSprite = this.getParticleTexture(worldObj, blockPos);
        ParticleHandlerUtil.addBlockLandingEffects(worldObj, entityPos, (TextureAtlasSprite)atlasSprite.getLeft(), (Integer)atlasSprite.getRight(), particleManager, numberOfParticles);
    }

    public boolean addRunningEffects(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (world.field_72995_K) {
            Pair<TextureAtlasSprite, Integer> atlasSprite = this.getParticleTexture(world, pos);
            ParticleHandlerUtil.addBlockRunningEffects(world, entity, (TextureAtlasSprite)atlasSprite.getLeft(), (Integer)atlasSprite.getRight());
        }
        return true;
    }

    public boolean addLandingEffects(@Nonnull IBlockState state, @Nonnull WorldServer worldObj, @Nonnull BlockPos blockPosition, @Nonnull IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        PacketBlockParticle packet = new PacketBlockParticle(blockPosition, new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), numberOfParticles);
        GregTechAPI.networkHandler.sendToAllTracking((IPacket)packet, NetworkUtils.blockPoint((World)worldObj, blockPosition));
        return true;
    }
}

