/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

public interface IRotorHolder {
    public boolean isFrontFaceFree();

    public static int getBaseEfficiency() {
        return 100;
    }

    default public int getTotalEfficiency() {
        int rotorEfficiency = this.getRotorEfficiency();
        if (rotorEfficiency == -1) {
            return -1;
        }
        int holderEfficiency = this.getHolderEfficiency();
        if (holderEfficiency == -1) {
            return -1;
        }
        return Math.max(IRotorHolder.getBaseEfficiency(), rotorEfficiency * holderEfficiency / 100);
    }

    default public int getTotalPower() {
        return this.getHolderPowerMultiplier() * this.getRotorPower();
    }

    public boolean hasRotor();

    public int getRotorSpeed();

    public int getRotorEfficiency();

    public int getRotorPower();

    public int getRotorDurabilityPercent();

    public void damageRotor(int var1);

    public int getMaxRotorHolderSpeed();

    public int getHolderPowerMultiplier();

    public int getHolderEfficiency();
}

