/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BoilerRecipeLogic
extends AbstractRecipeLogic {
    private static final long STEAM_PER_WATER = 160L;
    private static final int FLUID_DRAIN_MULTIPLIER = 100;
    private static final int FLUID_BURNTIME_TO_EU = 8;
    private int currentHeat;
    private int lastTickSteamOutput;
    private int excessWater;
    private int excessFuel;
    private int excessProjectedEU;

    public BoilerRecipeLogic(MetaTileEntityLargeBoiler tileEntity) {
        super(tileEntity, null);
        this.fluidOutputs = Collections.emptyList();
        this.itemOutputs = NonNullList.func_191196_a();
    }

    @Override
    public void update() {
        if (!(this.isActive() && this.canProgressRecipe() && this.isWorkingEnabled() || this.currentHeat <= 0)) {
            this.setHeat(this.currentHeat - 1);
            this.setLastTickSteam(0);
        }
        super.update();
    }

    @Override
    protected boolean canProgressRecipe() {
        return super.canProgressRecipe() && (!(this.metaTileEntity instanceof IMultiblockController) || !((IMultiblockController)((Object)this.metaTileEntity)).isStructureObstructed());
    }

    @Override
    protected void trySearchNewRecipe() {
        MetaTileEntityLargeBoiler boiler = (MetaTileEntityLargeBoiler)this.metaTileEntity;
        if (ConfigHolder.machines.enableMaintenance && boiler.hasMaintenanceMechanics() && boiler.getNumMaintenanceProblems() > 5) {
            return;
        }
        FluidTankList importFluids = boiler.getImportFluids();
        NonNullList dummyList = NonNullList.func_191196_a();
        boolean didStartRecipe = false;
        for (IFluidTank fluidTank : importFluids.getFluidTanks()) {
            FluidStack fuelStack = fluidTank.drain(Integer.MAX_VALUE, false);
            if (fuelStack == null || ModHandler.isWater(fuelStack)) continue;
            Recipe dieselRecipe = RecipeMaps.COMBUSTION_GENERATOR_FUELS.findRecipe(GTValues.V[14], (List<ItemStack>)dummyList, Collections.singletonList(fuelStack));
            if (dieselRecipe != null && fuelStack.amount >= dieselRecipe.getFluidInputs().get(0).getAmount() * 100) {
                fluidTank.drain(dieselRecipe.getFluidInputs().get(0).getAmount() * 100, true);
                this.setMaxProgress(this.adjustBurnTimeForThrottle(Math.max(1, boiler.boilerType.runtimeBoost(Math.abs(dieselRecipe.getEUt()) * dieselRecipe.getDuration() / 8 / 2))));
                didStartRecipe = true;
                break;
            }
            Recipe denseFuelRecipe = RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.findRecipe(GTValues.V[14], (List<ItemStack>)dummyList, Collections.singletonList(fuelStack));
            if (denseFuelRecipe == null || fuelStack.amount < denseFuelRecipe.getFluidInputs().get(0).getAmount() * 100) continue;
            fluidTank.drain(denseFuelRecipe.getFluidInputs().get(0).getAmount() * 100, true);
            this.setMaxProgress(this.adjustBurnTimeForThrottle(Math.max(1, boiler.boilerType.runtimeBoost(Math.abs(denseFuelRecipe.getEUt()) * denseFuelRecipe.getDuration() / 8 * 2))));
            didStartRecipe = true;
            break;
        }
        if (!didStartRecipe) {
            IItemHandlerModifiable importItems = boiler.getImportItems();
            for (int i = 0; i < importItems.getSlots(); ++i) {
                ItemStack stack = importItems.getStackInSlot(i);
                int fuelBurnTime = (int)Math.ceil(ModHandler.getFuelValue(stack));
                if (fuelBurnTime / 80 <= 0 || FluidUtil.getFluidHandler((ItemStack)stack) != null) continue;
                this.excessFuel += fuelBurnTime % 80;
                int excessProgress = this.excessFuel / 80;
                this.excessFuel %= 80;
                this.setMaxProgress(excessProgress + this.adjustBurnTimeForThrottle(boiler.boilerType.runtimeBoost(fuelBurnTime / 80)));
                stack.func_190918_g(1);
                didStartRecipe = true;
                break;
            }
        }
        if (didStartRecipe) {
            this.progressTime = 1;
            this.recipeEUt = this.adjustEUtForThrottle(boiler.boilerType.steamPerTick());
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
            } else {
                this.setActive(true);
            }
        }
        this.metaTileEntity.getNotifiedItemInputList().clear();
        this.metaTileEntity.getNotifiedFluidInputList().clear();
    }

    @Override
    protected void updateRecipeProgress() {
        if (this.canRecipeProgress) {
            int generatedSteam = this.recipeEUt * this.getMaximumHeatFromMaintenance() / this.getMaximumHeat();
            if (generatedSteam > 0) {
                long amount = ((long)generatedSteam + 160L) / 160L;
                this.excessWater = (int)((long)this.excessWater + (amount * 160L - (long)generatedSteam));
                this.excessWater = (int)((long)this.excessWater % 160L);
                FluidStack drainedWater = GTUtility.getBoilerFluidFromContainer(this.getInputTank(), (int)(amount -= (long)this.excessWater / 160L), true);
                if (amount != 0L && (drainedWater == null || (long)drainedWater.amount < amount)) {
                    this.getMetaTileEntity().explodeMultiblock(this.currentHeat / this.getMaximumHeat() * 8);
                } else {
                    this.setLastTickSteam(generatedSteam);
                    this.getOutputTank().fill(ModHandler.getSteam(generatedSteam), true);
                }
            }
            if (this.currentHeat < this.getMaximumHeat()) {
                this.setHeat(this.currentHeat + 1);
            }
            if (++this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
        }
    }

    private int getMaximumHeatFromMaintenance() {
        if (ConfigHolder.machines.enableMaintenance) {
            return (int)Math.min((double)this.currentHeat, (1.0 - 0.1 * (double)this.getMetaTileEntity().getNumMaintenanceProblems()) * (double)this.getMaximumHeat());
        }
        return this.currentHeat;
    }

    private int adjustEUtForThrottle(int rawEUt) {
        int throttle = ((MetaTileEntityLargeBoiler)this.metaTileEntity).getThrottle();
        return Math.max(25, (int)((double)rawEUt * ((double)throttle / 100.0)));
    }

    private int adjustBurnTimeForThrottle(int rawBurnTime) {
        MetaTileEntityLargeBoiler boiler = (MetaTileEntityLargeBoiler)this.metaTileEntity;
        int EUt = boiler.boilerType.steamPerTick();
        int adjustedEUt = this.adjustEUtForThrottle(EUt);
        int adjustedBurnTime = rawBurnTime * EUt / adjustedEUt;
        this.excessProjectedEU += EUt * rawBurnTime - adjustedEUt * adjustedBurnTime;
        this.excessProjectedEU %= adjustedEUt;
        return adjustedBurnTime += this.excessProjectedEU / adjustedEUt;
    }

    private int getMaximumHeat() {
        return ((MetaTileEntityLargeBoiler)this.metaTileEntity).boilerType.getTicksToBoiling();
    }

    public int getHeatScaled() {
        return (int)Math.round((double)this.currentHeat / (1.0 * (double)this.getMaximumHeat()) * 100.0);
    }

    public void setHeat(int heat) {
        if (heat != this.currentHeat && !this.metaTileEntity.getWorld().field_72995_K) {
            this.writeCustomData(15, b -> b.func_150787_b(heat));
        }
        this.currentHeat = heat;
    }

    public int getLastTickSteam() {
        return this.lastTickSteamOutput;
    }

    public void setLastTickSteam(int lastTickSteamOutput) {
        if (lastTickSteamOutput != this.lastTickSteamOutput && !this.metaTileEntity.getWorld().field_72995_K) {
            this.writeCustomData(16, b -> b.func_150787_b(lastTickSteamOutput));
        }
        this.lastTickSteamOutput = lastTickSteamOutput;
    }

    public void invalidate() {
        this.progressTime = 0;
        this.maxProgressTime = 0;
        this.recipeEUt = 0;
        this.setActive(false);
        this.setLastTickSteam(0);
    }

    @Override
    protected void completeRecipe() {
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.wasActiveAndNeedsUpdate = true;
    }

    @Override
    @Nonnull
    public MetaTileEntityLargeBoiler getMetaTileEntity() {
        return (MetaTileEntityLargeBoiler)super.getMetaTileEntity();
    }

    @Override
    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("Heat", this.currentHeat);
        compound.func_74768_a("ExcessFuel", this.excessFuel);
        compound.func_74768_a("ExcessWater", this.excessWater);
        compound.func_74768_a("ExcessProjectedEU", this.excessProjectedEU);
        return compound;
    }

    @Override
    public void deserializeNBT(@Nonnull NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.currentHeat = compound.func_74762_e("Heat");
        this.excessFuel = compound.func_74762_e("ExcessFuel");
        this.excessWater = compound.func_74762_e("ExcessWater");
        this.excessProjectedEU = compound.func_74762_e("ExcessProjectedEU");
    }

    @Override
    public void writeInitialData(@Nonnull PacketBuffer buf) {
        super.writeInitialData(buf);
        buf.func_150787_b(this.currentHeat);
        buf.func_150787_b(this.lastTickSteamOutput);
    }

    @Override
    public void receiveInitialData(@Nonnull PacketBuffer buf) {
        super.receiveInitialData(buf);
        this.currentHeat = buf.func_150792_a();
        this.lastTickSteamOutput = buf.func_150792_a();
    }

    @Override
    public void receiveCustomData(int dataId, @Nonnull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 15) {
            this.currentHeat = buf.func_150792_a();
        } else if (dataId == 16) {
            this.lastTickSteamOutput = buf.func_150792_a();
        }
    }

    @Override
    protected long getEnergyInputPerSecond() {
        GTLog.logger.error("Large Boiler called getEnergyInputPerSecond(), this should not be possible!");
        return 0L;
    }

    @Override
    protected long getEnergyStored() {
        GTLog.logger.error("Large Boiler called getEnergyStored(), this should not be possible!");
        return 0L;
    }

    @Override
    protected long getEnergyCapacity() {
        GTLog.logger.error("Large Boiler called getEnergyCapacity(), this should not be possible!");
        return 0L;
    }

    @Override
    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        GTLog.logger.error("Large Boiler called drawEnergy(), this should not be possible!");
        return false;
    }

    @Override
    protected long getMaxVoltage() {
        GTLog.logger.error("Large Boiler called getMaxVoltage(), this should not be possible!");
        return 0L;
    }
}

