/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ElectricItem
implements IElectricItem,
ICapabilityProvider {
    protected final ItemStack itemStack;
    protected final long maxCharge;
    protected final int tier;
    protected final boolean chargeable;
    protected final boolean canProvideEnergyExternally;
    protected final List<BiConsumer<ItemStack, Long>> listeners = new ArrayList<BiConsumer<ItemStack, Long>>();

    public ElectricItem(ItemStack itemStack, long maxCharge, int tier, boolean chargeable, boolean canProvideEnergyExternally) {
        this.itemStack = itemStack;
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.chargeable = chargeable;
        this.canProvideEnergyExternally = canProvideEnergyExternally;
    }

    @Override
    public void addChargeListener(BiConsumer<ItemStack, Long> chargeListener) {
        this.listeners.add(chargeListener);
    }

    public void setCharge(long change) {
        if (!this.itemStack.func_77942_o()) {
            this.itemStack.func_77982_d(new NBTTagCompound());
        }
        this.itemStack.func_77978_p().func_74772_a("Charge", change);
        this.listeners.forEach(l -> l.accept(this.itemStack, change));
    }

    public void setMaxChargeOverride(long maxCharge) {
        if (!this.itemStack.func_77942_o()) {
            this.itemStack.func_77982_d(new NBTTagCompound());
        }
        this.itemStack.func_77978_p().func_74772_a("MaxCharge", maxCharge);
    }

    @Override
    public long getTransferLimit() {
        return GTValues.V[this.getTier()];
    }

    @Override
    public long getMaxCharge() {
        NBTTagCompound tagCompound = this.itemStack.func_77978_p();
        if (tagCompound == null) {
            return this.maxCharge;
        }
        if (tagCompound.func_150297_b("MaxCharge", 4)) {
            return tagCompound.func_74763_f("MaxCharge");
        }
        return this.maxCharge;
    }

    @Override
    public long getCharge() {
        NBTTagCompound tagCompound = this.itemStack.func_77978_p();
        if (tagCompound == null) {
            return 0L;
        }
        if (tagCompound.func_74767_n("Infinite")) {
            return this.getMaxCharge();
        }
        return Math.min(tagCompound.func_74763_f("Charge"), this.getMaxCharge());
    }

    public void setInfiniteCharge(boolean infiniteCharge) {
        if (!this.itemStack.func_77942_o()) {
            this.itemStack.func_77982_d(new NBTTagCompound());
        }
        this.itemStack.func_77978_p().func_74757_a("Infinite", infiniteCharge);
        this.listeners.forEach(l -> l.accept(this.itemStack, this.getMaxCharge()));
    }

    @Override
    public boolean canProvideChargeExternally() {
        return this.canProvideEnergyExternally;
    }

    @Override
    public boolean chargeable() {
        return this.chargeable;
    }

    @Override
    public long charge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.itemStack.func_190916_E() != 1) {
            return 0L;
        }
        if ((this.chargeable || amount == Long.MAX_VALUE) && chargerTier >= this.tier && amount > 0L) {
            long canReceive = this.getMaxCharge() - this.getCharge();
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, this.getTransferLimit());
            }
            long charged = Math.min(amount, canReceive);
            if (!simulate) {
                this.setCharge(this.getCharge() + charged);
            }
            return charged;
        }
        return 0L;
    }

    @Override
    public long discharge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (this.itemStack.func_190916_E() != 1) {
            return 0L;
        }
        if ((this.canProvideEnergyExternally || !externally || amount == Long.MAX_VALUE) && chargerTier >= this.tier && amount > 0L) {
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, this.getTransferLimit());
            }
            long charge = this.getCharge();
            long discharged = Math.min(amount, charge);
            if (!simulate) {
                this.setCharge(charge - discharged);
            }
            return discharged;
        }
        return 0L;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM ? this : null);
    }
}

