/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class EnergyContainerBatteryBuffer
extends EnergyContainerHandler {
    public static final long AMPS_PER_BATTERY = 2L;
    private final int tier;

    public EnergyContainerBatteryBuffer(MetaTileEntity metaTileEntity, int tier, int inventorySize) {
        super(metaTileEntity, GTValues.V[tier] * (long)inventorySize * 32L, GTValues.V[tier], (long)inventorySize * 2L, GTValues.V[tier], inventorySize);
        this.tier = tier;
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        if (amperage <= 0L || voltage <= 0L) {
            return 0L;
        }
        List<Object> batteries = this.getNonFullBatteries();
        long maxAmps = (long)batteries.size() * 2L - this.amps;
        long usedAmps = Math.min(maxAmps, amperage);
        if (maxAmps <= 0L) {
            return 0L;
        }
        if (side == null || this.inputsEnergy(side)) {
            if (voltage > this.getInputVoltage()) {
                this.metaTileEntity.doExplosion(GTUtility.getExplosionPower(voltage));
                return usedAmps;
            }
            long internalAmps = Math.min(maxAmps, Math.max(0L, this.getInternalStorage() / voltage));
            usedAmps = Math.min(usedAmps, maxAmps - internalAmps);
            this.amps += usedAmps;
            this.energyInputPerSec += usedAmps * voltage;
            long energy = (usedAmps + internalAmps) * voltage;
            long distributed = energy / (long)batteries.size();
            for (Object item : batteries) {
                if (item instanceof IElectricItem) {
                    IElectricItem electricItem = (IElectricItem)item;
                    energy -= electricItem.charge(Math.min(distributed, GTValues.V[electricItem.getTier()] * 2L), this.getTier(), true, false);
                    continue;
                }
                if (!(item instanceof IEnergyStorage)) continue;
                IEnergyStorage energyStorage = (IEnergyStorage)item;
                energy -= FeCompat.insertEu(energyStorage, Math.min(distributed, GTValues.V[this.getTier()] * 2L));
            }
            this.setEnergyStored(this.getInternalStorage() - internalAmps * voltage + energy);
            return usedAmps;
        }
        return 0L;
    }

    @Override
    public void update() {
        this.amps = 0L;
        if (this.metaTileEntity.getWorld().field_72995_K) {
            return;
        }
        if (this.metaTileEntity.getOffsetTimer() % 20L == 0L) {
            this.lastEnergyInputPerSec = this.energyInputPerSec;
            this.lastEnergyOutputPerSec = this.energyOutputPerSec;
            this.energyInputPerSec = 0L;
            this.energyOutputPerSec = 0L;
        }
        EnumFacing outFacing = this.metaTileEntity.getFrontFacing();
        TileEntity tileEntity = this.metaTileEntity.getWorld().func_175625_s(this.metaTileEntity.getPos().func_177972_a(outFacing));
        if (tileEntity == null) {
            return;
        }
        IEnergyContainer energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, outFacing.func_176734_d());
        if (energyContainer == null) {
            return;
        }
        long voltage = this.getOutputVoltage();
        List<IElectricItem> batteries = this.getNonEmptyBatteries();
        if (batteries.size() > 0) {
            long internalAmps = Math.abs(Math.min(0L, this.getInternalStorage() / voltage));
            long genAmps = Math.max(0L, (long)batteries.size() - internalAmps);
            long outAmps = 0L;
            if (genAmps > 0L) {
                outAmps = energyContainer.acceptEnergyFromNetwork(outFacing.func_176734_d(), voltage, genAmps);
                if (outAmps == 0L && internalAmps == 0L) {
                    return;
                }
                this.energyOutputPerSec += outAmps * voltage;
            }
            long energy = (outAmps + internalAmps) * voltage;
            long distributed = energy / (long)batteries.size();
            for (IElectricItem electricItem : batteries) {
                energy -= electricItem.discharge(distributed, this.getTier(), false, true, false);
            }
            this.setEnergyStored(this.getInternalStorage() + internalAmps * voltage - energy);
        }
    }

    private long getInternalStorage() {
        return this.energyStored;
    }

    private List<Object> getNonFullBatteries() {
        IItemHandlerModifiable inventory = this.getInventory();
        ArrayList<Object> batteries = new ArrayList<Object>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage energyStorage;
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem != null) {
                if (electricItem.getCharge() >= electricItem.getMaxCharge()) continue;
                batteries.add(electricItem);
                continue;
            }
            if (!ConfigHolder.compat.energy.nativeEUToFE || (energyStorage = (IEnergyStorage)batteryStack.getCapability(CapabilityEnergy.ENERGY, null)) == null || energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) continue;
            batteries.add(energyStorage);
        }
        return batteries;
    }

    private List<IElectricItem> getNonEmptyBatteries() {
        IItemHandlerModifiable inventory = this.getInventory();
        ArrayList<IElectricItem> batteries = new ArrayList<IElectricItem>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem == null || !electricItem.canProvideChargeExternally() || electricItem.getCharge() <= 0L) continue;
            batteries.add(electricItem);
        }
        return batteries;
    }

    @Override
    public long getEnergyCapacity() {
        long energyCapacity = 0L;
        IItemHandlerModifiable inventory = this.getInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage energyStorage;
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem != null) {
                energyCapacity += electricItem.getMaxCharge();
                continue;
            }
            if (!ConfigHolder.compat.energy.nativeEUToFE || (energyStorage = (IEnergyStorage)batteryStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) continue;
            energyCapacity += FeCompat.toEu(energyStorage.getMaxEnergyStored(), FeCompat.ratio(false));
        }
        return energyCapacity;
    }

    @Override
    public long getEnergyStored() {
        long energyStored = 0L;
        IItemHandlerModifiable inventory = this.getInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage energyStorage;
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem != null) {
                energyStored += electricItem.getCharge();
                continue;
            }
            if (!ConfigHolder.compat.energy.nativeEUToFE || (energyStorage = (IEnergyStorage)batteryStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) continue;
            energyStored += FeCompat.toEu(energyStorage.getEnergyStored(), FeCompat.ratio(false));
        }
        return energyStored;
    }

    @Override
    public void setEnergyStored(long energyStored) {
        this.energyStored = energyStored;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.notifyEnergyListener(false);
        }
    }

    public IElectricItem getBatteryContainer(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null && this.getTier() >= electricItem.getTier()) {
            return electricItem;
        }
        return null;
    }

    @Override
    public void notifyEnergyListener(boolean isInitialChange) {
        if (this.metaTileEntity instanceof EnergyContainerHandler.IEnergyChangeListener) {
            ((EnergyContainerHandler.IEnergyChangeListener)((Object)this.metaTileEntity)).onEnergyChanged(this, isInitialChange);
        }
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return this.getMetaTileEntity().getFrontFacing() != side;
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return !this.inputsEnergy(side);
    }

    @Override
    @Nonnull
    public final String getName() {
        return "BatteryEnergyContainer";
    }

    protected IItemHandlerModifiable getInventory() {
        return this.metaTileEntity.getImportItems();
    }

    protected int getTier() {
        return this.tier;
    }
}

