/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.ItemStackHandler;

public class FilteredItemHandler
extends ItemStackHandler {
    private Predicate<ItemStack> fillPredicate;

    public static Predicate<ItemStack> getCapabilityFilter(Capability<?> cap) {
        return stack -> stack.hasCapability(cap, null);
    }

    public FilteredItemHandler() {
        super(1);
    }

    public FilteredItemHandler(int size) {
        super(size);
    }

    public FilteredItemHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public FilteredItemHandler setFillPredicate(Predicate<ItemStack> fillPredicate) {
        this.fillPredicate = fillPredicate;
        return this;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.fillPredicate == null || this.fillPredicate.test(stack);
    }
}

