/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IMultipleTankHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTankList
implements IFluidHandler,
IMultipleTankHandler,
INBTSerializable<NBTTagCompound> {
    protected final List<IFluidTank> fluidTanks;
    protected IFluidTankProperties[] properties;
    private final boolean allowSameFluidFill;
    private IFluidTankProperties[] fluidTankProperties;
    private final int hashCode;

    public FluidTankList(boolean allowSameFluidFill, IFluidTank ... fluidTanks) {
        this.fluidTanks = Arrays.asList(fluidTanks);
        this.allowSameFluidFill = allowSameFluidFill;
        this.hashCode = Arrays.hashCode(fluidTanks);
    }

    public FluidTankList(boolean allowSameFluidFill, List<? extends IFluidTank> fluidTanks) {
        this.fluidTanks = new ArrayList<IFluidTank>(fluidTanks);
        this.allowSameFluidFill = allowSameFluidFill;
        this.hashCode = Arrays.hashCode(fluidTanks.toArray());
    }

    public FluidTankList(boolean allowSameFluidFill, FluidTankList parent, IFluidTank ... additionalTanks) {
        this.fluidTanks = new ArrayList<IFluidTank>();
        this.fluidTanks.addAll(parent.fluidTanks);
        this.fluidTanks.addAll(Arrays.asList(additionalTanks));
        this.allowSameFluidFill = allowSameFluidFill;
        int hash = Objects.hash(parent);
        this.hashCode = hash = 31 * hash + Arrays.hashCode(additionalTanks);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public List<IFluidTank> getFluidTanks() {
        return Collections.unmodifiableList(this.fluidTanks);
    }

    @Override
    @Nonnull
    public Iterator<IFluidTank> iterator() {
        return this.getFluidTanks().iterator();
    }

    @Override
    public int getTanks() {
        return this.fluidTanks.size();
    }

    @Override
    public IFluidTank getTankAt(int index) {
        return this.fluidTanks.get(index);
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.fluidTankProperties == null) {
            ArrayList<IFluidTankProperties> propertiesList = new ArrayList<IFluidTankProperties>();
            for (IFluidTank fluidTank : this.fluidTanks) {
                if (!(fluidTank instanceof IFluidHandler)) continue;
                IFluidHandler fluidHandler = (IFluidHandler)fluidTank;
                propertiesList.addAll(Arrays.asList(fluidHandler.getTankProperties()));
            }
            this.fluidTankProperties = propertiesList.toArray(new IFluidTankProperties[0]);
        }
        return this.fluidTankProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        return this.fillTanksImpl(resource.copy(), doFill);
    }

    private int fillTanksImpl(FluidStack resource, boolean doFill) {
        int filledAmount;
        int totalFilled = 0;
        for (IFluidTank handler : this.fluidTanks) {
            if (!resource.isFluidEqual(handler.getFluid())) continue;
            filledAmount = handler.fill(resource, doFill);
            totalFilled += filledAmount;
            resource.amount -= filledAmount;
            if (this.allowSameFluidFill() && resource.amount != 0) continue;
            return totalFilled;
        }
        for (IFluidTank handler : this.fluidTanks) {
            if (handler.getFluidAmount() != 0) continue;
            filledAmount = handler.fill(resource, doFill);
            totalFilled += filledAmount;
            resource.amount -= filledAmount;
            if (this.allowSameFluidFill() && resource.amount != 0) continue;
            return totalFilled;
        }
        return totalFilled;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        resource = resource.copy();
        FluidStack totalDrained = null;
        for (IFluidTank handler : this.fluidTanks) {
            FluidStack drain;
            if (!resource.isFluidEqual(handler.getFluid()) || (drain = handler.drain(resource.amount, doDrain)) == null) continue;
            if (totalDrained == null) {
                totalDrained = drain;
            } else {
                totalDrained.amount += drain.amount;
            }
            resource.amount -= drain.amount;
            if (resource.amount != 0) continue;
            break;
        }
        return totalDrained;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain == 0) {
            return null;
        }
        FluidStack totalDrained = null;
        for (IFluidTank handler : this.fluidTanks) {
            if (totalDrained == null) {
                totalDrained = handler.drain(maxDrain, doDrain);
                if (totalDrained != null) {
                    maxDrain -= totalDrained.amount;
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.amount = maxDrain;
                if (!copy.isFluidEqual(handler.getFluid())) continue;
                FluidStack drain = handler.drain(copy.amount, doDrain);
                if (drain != null) {
                    totalDrained.amount += drain.amount;
                    maxDrain -= drain.amount;
                }
            }
            if (maxDrain > 0) continue;
            break;
        }
        return totalDrained;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound fluidInventory = new NBTTagCompound();
        fluidInventory.func_74768_a("TankAmount", this.getTanks());
        NBTTagList tanks = new NBTTagList();
        for (int i = 0; i < this.getTanks(); ++i) {
            IFluidTank fluidTank = this.fluidTanks.get(i);
            Object writeTag = fluidTank instanceof FluidTank ? ((FluidTank)fluidTank).writeToNBT(new NBTTagCompound()) : (fluidTank instanceof INBTSerializable ? ((INBTSerializable)fluidTank).serializeNBT() : new NBTTagCompound());
            tanks.func_74742_a((NBTBase)writeTag);
        }
        fluidInventory.func_74782_a("Tanks", (NBTBase)tanks);
        return fluidInventory;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList tanks = nbt.func_150295_c("Tanks", 10);
        for (int i = 0; i < Math.min(this.fluidTanks.size(), nbt.func_74762_e("TankAmount")); ++i) {
            NBTBase nbtTag = tanks.func_179238_g(i);
            IFluidTank fluidTank = this.fluidTanks.get(i);
            if (fluidTank instanceof FluidTank) {
                ((FluidTank)fluidTank).readFromNBT((NBTTagCompound)nbtTag);
                continue;
            }
            if (!(fluidTank instanceof INBTSerializable)) continue;
            ((INBTSerializable)fluidTank).deserializeNBT(nbtTag);
        }
    }

    protected void validateTankIndex(int tank) {
        if (tank < 0 || tank >= this.fluidTanks.size()) {
            throw new RuntimeException("Tank " + tank + " not in valid range - (0," + this.fluidTanks.size() + "]");
        }
    }

    @Override
    public int getIndexOfFluid(FluidStack fluidStack) {
        for (int i = 0; i < this.fluidTanks.size(); ++i) {
            FluidStack tankStack = this.fluidTanks.get(i).getFluid();
            if (tankStack == null || !tankStack.isFluidEqual(fluidStack)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean allowSameFluidFill() {
        return this.allowSameFluidFill;
    }
}

