/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.INotifiableHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GhostCircuitItemStackHandler
implements IItemHandlerModifiable,
INotifiableHandler {
    public static final int NO_CONFIG = -1;
    private final List<MetaTileEntity> notifiableEntities = new ArrayList<MetaTileEntity>();
    private int circuitValue = -1;
    private ItemStack circuitStack = ItemStack.field_190927_a;

    public int getCircuitValue() {
        return this.circuitValue;
    }

    public boolean hasCircuitValue() {
        return this.circuitValue != -1;
    }

    public void setCircuitValue(int config) {
        if (config == -1) {
            this.circuitValue = -1;
            this.circuitStack = ItemStack.field_190927_a;
        } else if (config >= 0 && config <= 32) {
            this.circuitValue = config;
            this.circuitStack = IntCircuitIngredient.getIntegratedCircuit(config);
        } else {
            throw new IllegalArgumentException("Circuit value out of range: " + config);
        }
        for (MetaTileEntity mte : this.notifiableEntities) {
            if (mte == null || !mte.isValid()) continue;
            this.addToNotifiedList(mte, this, false);
        }
    }

    public void setCircuitValueFromStack(@Nonnull ItemStack stack) {
        this.setCircuitValue(!stack.func_190926_b() && IntCircuitIngredient.isIntegratedCircuit(stack) ? IntCircuitIngredient.getCircuitConfiguration(stack) : -1);
    }

    public void addCircuitValue(int configDelta) {
        if (this.hasCircuitValue()) {
            this.setCircuitValue(MathHelper.func_76125_a((int)(this.getCircuitValue() + configDelta), (int)0, (int)32));
        }
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlot(slot);
        this.setCircuitValueFromStack(stack);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        return this.circuitStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlot(slot);
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlot(slot);
        if (!simulate) {
            this.setCircuitValue(-1);
        }
        return this.circuitStack;
    }

    public int getSlotLimit(int slot) {
        this.validateSlot(slot);
        return 1;
    }

    protected void validateSlot(int slot) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Slot index out of bounds: " + slot);
        }
    }

    @Override
    public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        if (metaTileEntity == null) {
            return;
        }
        this.notifiableEntities.add(metaTileEntity);
    }

    @Override
    public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        this.notifiableEntities.remove(metaTileEntity);
    }

    public void write(@Nonnull NBTTagCompound tag) {
        if (this.circuitValue != -1) {
            tag.func_74774_a("GhostCircuit", (byte)this.circuitValue);
        }
    }

    public void read(@Nonnull NBTTagCompound tag) {
        int circuitValue;
        int n = circuitValue = tag.func_150297_b("GhostCircuit", 99) ? tag.func_74762_e("GhostCircuit") : -1;
        if (circuitValue < 0 || circuitValue > 32) {
            circuitValue = -1;
        }
        this.setCircuitValue(circuitValue);
    }
}

