/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.util.GTLog;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public final class CoverIO {
    public static final int NO_COVER_ID = -1;

    private CoverIO() {
    }

    public static void writeCoverSyncData(@Nonnull PacketBuffer buf, @Nonnull ICoverable coverable) {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = coverable.getCoverAtSide(coverSide);
            if (coverBehavior != null) {
                buf.func_150787_b(CoverDefinition.getNetworkIdForCover(coverBehavior.getCoverDefinition()));
                coverBehavior.writeInitialSyncData(buf);
                continue;
            }
            buf.func_150787_b(-1);
        }
    }

    public static void receiveCoverSyncData(@Nonnull PacketBuffer buf, @Nonnull ICoverable coverable, @Nonnull BiConsumer<EnumFacing, CoverBehavior> coverWriter) {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            int id = buf.func_150792_a();
            if (id == -1) continue;
            CoverDefinition definition = CoverDefinition.getCoverByNetworkId(id);
            if (definition == null) {
                GTLog.logger.warn("Unable to find CoverDefinition for Network ID {} at position {}", (Object)id, (Object)coverable.getPos());
                continue;
            }
            CoverBehavior coverBehavior = definition.createCoverBehavior(coverable, coverSide);
            coverBehavior.readInitialSyncData(buf);
            coverWriter.accept(coverSide, coverBehavior);
        }
    }

    @Nonnull
    public static Consumer<PacketBuffer> getCoverPlacementCustomDataWriter(@Nonnull EnumFacing side, @Nonnull CoverBehavior behavior) {
        return buffer -> {
            buffer.writeByte(side.func_176745_a());
            buffer.func_150787_b(CoverDefinition.getNetworkIdForCover(behavior.getCoverDefinition()));
            behavior.writeInitialSyncData((PacketBuffer)buffer);
        };
    }

    public static void readCoverPlacement(@Nonnull PacketBuffer buf, @Nonnull ICoverable coverable, @Nonnull BiConsumer<EnumFacing, CoverBehavior> coverWriter, @Nonnull Runnable renderUpdater) {
        EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
        int id = buf.func_150792_a();
        CoverDefinition coverDefinition = CoverDefinition.getCoverByNetworkId(id);
        if (coverDefinition == null) {
            GTLog.logger.warn("Unable to find CoverDefinition for Network ID {} at position {}", (Object)id, (Object)coverable.getPos());
        } else {
            CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(coverable, placementSide);
            coverWriter.accept(placementSide, coverBehavior);
            coverBehavior.readInitialSyncData(buf);
        }
        renderUpdater.run();
    }

    public static void writeCoverNBT(@Nonnull NBTTagCompound tagCompound, @Nonnull Function<EnumFacing, CoverBehavior> coverReader) {
        NBTTagList coversList = new NBTTagList();
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = coverReader.apply(coverSide);
            if (coverBehavior == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            ResourceLocation coverId = coverBehavior.getCoverDefinition().getCoverId();
            tag.func_74778_a("CoverId", coverId.toString());
            tag.func_74774_a("Side", (byte)coverSide.func_176745_a());
            coverBehavior.writeToNBT(tag);
            coversList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Covers", (NBTBase)coversList);
    }

    public static void readCoverNBT(@Nonnull NBTTagCompound tagCompound, @Nonnull ICoverable coverable, @Nonnull BiConsumer<EnumFacing, CoverBehavior> coverWriter) {
        NBTTagList coversList = tagCompound.func_150295_c("Covers", 10);
        for (int index = 0; index < coversList.func_74745_c(); ++index) {
            NBTTagCompound tag = coversList.func_150305_b(index);
            if (!tag.func_150297_b("CoverId", 8)) continue;
            EnumFacing coverSide = EnumFacing.field_82609_l[tag.func_74771_c("Side")];
            ResourceLocation coverLocation = new ResourceLocation(tag.func_74779_i("CoverId"));
            CoverDefinition coverDefinition = CoverDefinition.getCoverById(coverLocation);
            if (coverDefinition == null) {
                GTLog.logger.warn("Unable to find CoverDefinition for ResourceLocation {} at position {}", (Object)coverLocation, (Object)coverable.getPos());
                continue;
            }
            CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(coverable, coverSide);
            coverBehavior.readFromNBT(tag);
            coverWriter.accept(coverSide, coverBehavior);
        }
    }
}

