/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.RenderUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ICoverable {
    public static final Transformation REVERSE_HORIZONTAL_ROTATION = new Rotation(Math.PI, new Vector3(0.0, 1.0, 0.0)).at(Vector3.center);
    public static final Transformation REVERSE_VERTICAL_ROTATION = new Rotation(Math.PI, new Vector3(1.0, 0.0, 0.0)).at(Vector3.center);

    public World getWorld();

    public BlockPos getPos();

    public long getOffsetTimer();

    public void markDirty();

    public boolean isValid();

    public <T> T getCapability(Capability<T> var1, EnumFacing var2);

    public boolean placeCoverOnSide(EnumFacing var1, ItemStack var2, CoverDefinition var3, EntityPlayer var4);

    public boolean removeCover(EnumFacing var1);

    public boolean canPlaceCoverOnSide(EnumFacing var1);

    public CoverBehavior getCoverAtSide(EnumFacing var1);

    public void writeCoverData(CoverBehavior var1, int var2, Consumer<PacketBuffer> var3);

    public int getInputRedstoneSignal(EnumFacing var1, boolean var2);

    public ItemStack getStackForm();

    public double getCoverPlateThickness();

    public int getPaintingColorForRendering();

    public boolean shouldRenderBackSide();

    public void notifyBlockUpdate();

    public void scheduleRenderUpdate();

    default public boolean hasAnyCover() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.getCoverAtSide(facing) == null) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderCovers(CCRenderState renderState, Matrix4 translation, BlockRenderLayer layer) {
        renderState.lightMatrix.locate((IBlockAccess)this.getWorld(), this.getPos());
        double coverPlateThickness = this.getCoverPlateThickness();
        IVertexOperation[] platePipeline = new IVertexOperation[]{renderState.lightMatrix, new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))};
        IVertexOperation[] coverPipeline = new IVertexOperation[]{renderState.lightMatrix};
        for (EnumFacing sideFacing : EnumFacing.values()) {
            CoverBehavior coverBehavior = this.getCoverAtSide(sideFacing);
            if (coverBehavior == null) continue;
            Cuboid6 plateBox = ICoverable.getCoverPlateBox(sideFacing, coverPlateThickness);
            if (coverBehavior.canRenderInLayer(layer) && coverPlateThickness > 0.0) {
                renderState.preRenderWorld((IBlockAccess)this.getWorld(), this.getPos());
                coverBehavior.renderCoverPlate(renderState, translation, platePipeline, plateBox, layer);
            }
            if (!coverBehavior.canRenderInLayer(layer)) continue;
            coverBehavior.renderCover(renderState, RenderUtil.adjustTrans(translation, sideFacing, 2), coverPipeline, plateBox, layer);
            if (coverPlateThickness != 0.0 || !this.shouldRenderBackSide() || !coverBehavior.canRenderBackside()) continue;
            Matrix4 backTranslation = translation.copy();
            if (sideFacing.func_176740_k().func_176720_b()) {
                REVERSE_VERTICAL_ROTATION.apply(backTranslation);
            } else {
                REVERSE_HORIZONTAL_ROTATION.apply(backTranslation);
            }
            backTranslation.translate((double)(-sideFacing.func_82601_c()), (double)(-sideFacing.func_96559_d()), (double)(-sideFacing.func_82599_e()));
            coverBehavior.renderCover(renderState, backTranslation, coverPipeline, plateBox, layer);
        }
    }

    default public void addCoverCollisionBoundingBox(List<? super IndexedCuboid6> collisionList) {
        double plateThickness = this.getCoverPlateThickness();
        if (plateThickness > 0.0) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (this.getCoverAtSide(side) == null) continue;
                Cuboid6 coverBox = ICoverable.getCoverPlateBox(side, plateThickness);
                CoverSideData coverSideData = new CoverSideData(side);
                collisionList.add((IndexedCuboid6)new IndexedCuboid6((Object)coverSideData, coverBox));
            }
        }
    }

    public static boolean doesCoverCollide(EnumFacing side, List<IndexedCuboid6> collisionBox, double plateThickness) {
        if (side == null) {
            return false;
        }
        if (plateThickness > 0.0) {
            Cuboid6 coverPlateBox = ICoverable.getCoverPlateBox(side, plateThickness);
            for (Cuboid6 cuboid6 : collisionBox) {
                if (!cuboid6.intersects(coverPlateBox)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static EnumFacing rayTraceCoverableSide(ICoverable coverable, EntityPlayer player) {
        RayTraceResult result = RayTracer.retraceBlock((World)coverable.getWorld(), (EntityPlayer)player, (BlockPos)coverable.getPos());
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return ICoverable.traceCoverSide(result);
    }

    public static EnumFacing traceCoverSide(RayTraceResult result) {
        if (result instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)result;
            if (rayTraceResult.cuboid6.data == null) {
                return ICoverable.determineGridSideHit(result);
            }
            if (rayTraceResult.cuboid6.data instanceof CoverSideData) {
                return ((CoverSideData)rayTraceResult.cuboid6.data).side;
            }
            if (rayTraceResult.cuboid6.data instanceof BlockPipe.PipeConnectionData) {
                return ((BlockPipe.PipeConnectionData)rayTraceResult.cuboid6.data).side;
            }
            if (rayTraceResult.cuboid6.data instanceof PrimaryBoxData) {
                PrimaryBoxData primaryBoxData = (PrimaryBoxData)rayTraceResult.cuboid6.data;
                return primaryBoxData.usePlacementGrid ? ICoverable.determineGridSideHit(result) : result.field_178784_b;
            }
        }
        return ICoverable.determineGridSideHit(result);
    }

    public static EnumFacing determineGridSideHit(RayTraceResult result) {
        return GTUtility.determineWrenchingSide(result.field_178784_b, (float)(result.field_72307_f.field_72450_a - (double)result.func_178782_a().func_177958_n()), (float)(result.field_72307_f.field_72448_b - (double)result.func_178782_a().func_177956_o()), (float)(result.field_72307_f.field_72449_c - (double)result.func_178782_a().func_177952_p()));
    }

    public static Cuboid6 getCoverPlateBox(EnumFacing side, double plateThickness) {
        switch (side) {
            case UP: {
                return new Cuboid6(0.0, 1.0 - plateThickness, 0.0, 1.0, 1.0, 1.0);
            }
            case DOWN: {
                return new Cuboid6(0.0, 0.0, 0.0, 1.0, plateThickness, 1.0);
            }
            case NORTH: {
                return new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, plateThickness);
            }
            case SOUTH: {
                return new Cuboid6(0.0, 0.0, 1.0 - plateThickness, 1.0, 1.0, 1.0);
            }
            case WEST: {
                return new Cuboid6(0.0, 0.0, 0.0, plateThickness, 1.0, 1.0);
            }
            case EAST: {
                return new Cuboid6(1.0 - plateThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        throw new UnsupportedOperationException("Cannot get cover plate box at side " + side);
    }

    public static boolean canPlaceCover(CoverDefinition coverDef, ICoverable coverable) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            CoverBehavior cover = coverDef.createCoverBehavior(coverable, facing);
            if (!coverable.canPlaceCoverOnSide(facing) || !cover.canAttach()) continue;
            return true;
        }
        return false;
    }

    default public boolean canRenderMachineGrid(@Nonnull ItemStack mainHandStack, @Nonnull ItemStack offHandStack) {
        return true;
    }

    public static class CoverSideData {
        public final EnumFacing side;

        public CoverSideData(EnumFacing side) {
            this.side = side;
        }
    }

    public static class PrimaryBoxData {
        public final boolean usePlacementGrid;

        public PrimaryBoxData(boolean usePlacementGrid) {
            this.usePlacementGrid = usePlacementGrid;
        }
    }
}

