/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.damagesources;

import gregtech.api.damagesources.DamageSourceTool;
import gregtech.api.items.toolitem.IGTTool;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;

public class DamageSources {
    private static final DamageSource EXPLOSION = new DamageSource("explosion").func_94540_d();
    private static final DamageSource HEAT = new DamageSource("heat").func_76361_j();
    private static final DamageSource FROST = new DamageSource("frost");
    private static final DamageSource CHEMICAL = new DamageSource("chemical").func_76348_h();
    private static final DamageSource ELECTRIC = new DamageSource("electric");
    private static final DamageSource RADIATION = new DamageSource("radiation").func_76348_h();
    private static final DamageSource TURBINE = new DamageSource("turbine");

    public static DamageSource getExplodingDamage() {
        return EXPLOSION;
    }

    public static DamageSource getHeatDamage() {
        return HEAT;
    }

    public static DamageSource getFrostDamage() {
        return FROST;
    }

    public static DamageSource getChemicalDamage() {
        return CHEMICAL;
    }

    public static DamageSource getElectricDamage() {
        return ELECTRIC;
    }

    public static DamageSource getRadioactiveDamage() {
        return RADIATION;
    }

    public static DamageSource getTurbineDamage() {
        return TURBINE;
    }

    public static DamageSource getPlayerDamage(@Nullable EntityPlayer source) {
        ItemStack stack;
        ItemStack itemStack = stack = source != null ? source.func_184614_ca() : ItemStack.field_190927_a;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IGTTool) {
            IGTTool tool = (IGTTool)stack.func_77973_b();
            return new DamageSourceTool("player", (EntityLivingBase)source, String.format("death.attack.%s", tool.getId()));
        }
        return new EntityDamageSource("player", (Entity)source);
    }

    public static DamageSource getMobDamage(@Nullable EntityLivingBase source) {
        ItemStack stack;
        ItemStack itemStack = stack = source != null ? source.func_184582_a(EntityEquipmentSlot.MAINHAND) : ItemStack.field_190927_a;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IGTTool) {
            IGTTool tool = (IGTTool)stack.func_77973_b();
            return new DamageSourceTool("mob", source, String.format("death.attack.%s", tool.getId()));
        }
        return new EntityDamageSource("mob", (Entity)source);
    }
}

