/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ResourceHelper {
    public static final String RESOURCE_PREFIX = "gregtech:";
    private static final Map<String, ResourceLocation> cachedResources = new HashMap<String, ResourceLocation>();
    private static final String DIR_FORMAT = "textures/%s.png";

    private ResourceHelper() {
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static ResourceLocation getResource(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(RESOURCE_PREFIX + rs));
        }
        return cachedResources.get(rs);
    }

    public static ResourceLocation getResourceRAW(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(rs));
        }
        return cachedResources.get(rs);
    }

    public static void bindTexture(String rs) {
        ResourceHelper.bindTexture(ResourceHelper.getResource(rs));
    }

    public static boolean isResourceExist(String rs) {
        if (!cachedResources.containsKey(rs)) {
            URL url = ResourceHelper.class.getResource(String.format("/assets/%s/%s", "gregtech", rs));
            if (url == null) {
                return false;
            }
            cachedResources.put(rs, new ResourceLocation("gregtech", rs));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doResourcepacksHaveTexture(@Nonnull String modid, @Nonnull String textureResource, boolean format) {
        if (format) {
            textureResource = String.format(DIR_FORMAT, textureResource);
        }
        return ResourceHelper.doResourcepacksHaveResource(modid, textureResource);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doResourcepacksHaveResource(@Nonnull String modid, @Nonnull String resource) {
        return ResourceHelper.doResourcepacksHaveResource(new ResourceLocation(modid, resource));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doResourcepacksHaveResource(@Nonnull ResourceLocation resource) {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        try {
            manager.func_110536_a(resource);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isTextureExist(@Nonnull String modid, @Nonnull String textureResource) {
        URL url = ResourceHelper.class.getResource(String.format("/assets/%s/textures/%s.png", modid, textureResource));
        return url != null;
    }

    public static boolean isTextureExist(@Nonnull ResourceLocation textureResource) {
        return ResourceHelper.isTextureExist(textureResource.func_110624_b(), textureResource.func_110623_a());
    }
}

