/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.base.Preconditions;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.lwjgl.input.Mouse;

public class ClickButtonWidget
extends Widget {
    protected TextureArea buttonTexture = GuiTextures.VANILLA_BUTTON.getSubArea(0.0, 0.0, 1.0, 0.5);
    protected final String displayText;
    protected int textColor = 0xFFFFFF;
    protected final Consumer<Widget.ClickData> onPressCallback;
    protected boolean shouldClientCallback;
    protected Supplier<Boolean> shouldDisplay;
    private String tooltipText;
    private Object[] tooltipArgs;

    public ClickButtonWidget(int xPosition, int yPosition, int width, int height, String displayText, Consumer<Widget.ClickData> onPressed) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.displayText = displayText;
        this.onPressCallback = onPressed;
        this.shouldDisplay = () -> true;
    }

    public ClickButtonWidget setShouldClientCallback(boolean shouldClientCallback) {
        this.shouldClientCallback = shouldClientCallback;
        return this;
    }

    public ClickButtonWidget setButtonTexture(TextureArea buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public ClickButtonWidget setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public ClickButtonWidget setDisplayFunction(Supplier<Boolean> displayFunction) {
        this.shouldDisplay = displayFunction;
        return this;
    }

    public ClickButtonWidget setTooltipText(String tooltipText, Object ... args) {
        Preconditions.checkNotNull((Object)tooltipText, (Object)"tooltipText");
        this.tooltipText = tooltipText;
        this.tooltipArgs = args;
        return this;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.shouldDisplay.get() != false;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.shouldDisplay.get() != false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        if (!this.shouldDisplay.get().booleanValue()) {
            return;
        }
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(position.x, position.y, size.width, size.height, 0.0, 1.0);
        } else {
            this.buttonTexture.drawSubArea(position.x, position.y, size.width, size.height, 0.0, 0.0, 1.0, 1.0);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)this.displayText, (Object[])new Object[0]);
        fontRenderer.func_78276_b(text, position.x + size.width / 2 - fontRenderer.func_78256_a(text) / 2, position.y + size.height / 2 - fontRenderer.field_78288_b / 2, this.textColor);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        if (this.tooltipText != null && this.isMouseOverElement(mouseX, mouseY)) {
            List<String> hoverList = Arrays.asList(GTUtility.getForwardNewLineRegex().split(I18n.func_135052_a((String)this.tooltipText, (Object[])this.tooltipArgs)));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.shouldDisplay.get().booleanValue()) {
            return false;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.triggerButton();
            return true;
        }
        return false;
    }

    protected void triggerButton() {
        Widget.ClickData clickData = new Widget.ClickData(Mouse.getEventButton(), ClickButtonWidget.isShiftDown(), ClickButtonWidget.isCtrlDown());
        this.writeClientAction(1, clickData::writeToBuf);
        if (this.shouldClientCallback) {
            this.onPressCallback.accept(new Widget.ClickData(Mouse.getEventButton(), ClickButtonWidget.isShiftDown(), ClickButtonWidget.isCtrlDown(), true));
        }
        ClickButtonWidget.playButtonClickSound();
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            Widget.ClickData clickData = Widget.ClickData.readFromBuf(buffer);
            this.onPressCallback.accept(clickData);
        }
    }
}

