/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class GhostCircuitSlotWidget
extends SlotWidget {
    private static final int SET_TO_ZERO = 1;
    private static final int SET_TO_EMPTY = 2;
    private static final int SET_TO_N = 3;
    private final GhostCircuitItemStackHandler circuitInventory;

    public GhostCircuitSlotWidget(GhostCircuitItemStackHandler circuitInventory, int slotIndex, int xPosition, int yPosition) {
        super((IItemHandler)circuitInventory, slotIndex, xPosition, yPosition, false, false, false);
        this.circuitInventory = circuitInventory;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (button == 0 && !this.circuitInventory.hasCircuitValue()) {
                this.circuitInventory.setCircuitValue(0);
                this.writeClientAction(1, buf -> {});
            } else if (button == 1 && this.circuitInventory.hasCircuitValue()) {
                this.circuitInventory.setCircuitValue(-1);
                this.writeClientAction(2, buf -> {});
            } else {
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (this.circuitInventory.hasCircuitValue()) {
                int dir = wheelDelta >= 0 ? 1 : -1;
                int prevValue = this.circuitInventory.getCircuitValue();
                this.circuitInventory.addCircuitValue(dir * (GhostCircuitSlotWidget.isShiftDown() ? 5 : 1));
                int newValue = this.circuitInventory.getCircuitValue();
                if (prevValue != newValue) {
                    this.writeClientAction(3, buf -> buf.func_150787_b(newValue));
                }
            } else {
                super.mouseWheelMove(mouseX, mouseY, wheelDelta);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return false;
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stackHeld = player.field_71071_by.func_70445_o();
        if (IntCircuitIngredient.isIntegratedCircuit(stackHeld)) {
            this.circuitInventory.setCircuitValueFromStack(stackHeld);
            return this.circuitInventory.getStackInSlot(0).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        switch (id) {
            case 1: {
                this.circuitInventory.setCircuitValue(0);
                return;
            }
            case 2: {
                this.circuitInventory.setCircuitValue(-1);
                return;
            }
            case 3: {
                this.circuitInventory.setCircuitValue(buffer.func_150792_a());
            }
        }
    }
}

