/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IncrementButtonWidget
extends Widget {
    private TextureArea buttonTexture = GuiTextures.VANILLA_BUTTON.getSubArea(0.0, 0.0, 1.0, 0.5);
    private final int increment;
    private final int incrementShift;
    private final int incrementCtrl;
    private final int incrementShiftCtrl;
    private final IntConsumer updater;
    private int clickValue;
    private boolean shouldClientCallback;
    private String tooltip;
    protected long hoverStartTime = -1L;
    protected boolean isMouseHovered;
    protected float textScale = 1.0f;

    public IncrementButtonWidget(int x, int y, int width, int height, int increment, int incrementShift, int incrementCtrl, int incrementShiftCtrl, IntConsumer updater) {
        super(x, y, width, height);
        this.increment = increment;
        this.incrementShift = incrementShift;
        this.incrementCtrl = incrementCtrl;
        this.incrementShiftCtrl = incrementShiftCtrl;
        this.updater = updater;
        this.clickValue = increment;
    }

    public IncrementButtonWidget setButtonTexture(TextureArea buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public IncrementButtonWidget setShouldClientCallback(boolean shouldClientCallback) {
        this.shouldClientCallback = shouldClientCallback;
        return this;
    }

    public IncrementButtonWidget setDefaultTooltip() {
        this.tooltip = "gui.widget.incrementButton.default_tooltip";
        return this;
    }

    public IncrementButtonWidget setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public IncrementButtonWidget setTextScale(float textScale) {
        this.textScale = textScale;
        return this;
    }

    @Override
    public void updateScreen() {
        this.clickValue = this.getClickValue();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(position.x, position.y, size.width, size.height, 0.0, 1.0);
        } else {
            this.buttonTexture.drawSubArea(position.x, position.y, size.width, size.height, 0.0, 0.0, 1.0, 1.0);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String text = String.valueOf(this.clickValue);
        if (this.clickValue >= 0) {
            text = "+" + text;
        }
        IncrementButtonWidget.drawText(text, (float)position.x + (float)size.width / 2.0f - (float)fontRenderer.func_78256_a(text) / 2.0f * this.textScale, (float)position.y + (float)size.height / 2.0f - (float)fontRenderer.field_78288_b / 2.0f * this.textScale, this.textScale, 0xFFFFFF);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        long timeSinceHover;
        boolean isHovered = this.isMouseOverElement(mouseX, mouseY);
        boolean wasHovered = this.isMouseHovered;
        if (isHovered && !wasHovered) {
            this.isMouseHovered = true;
            this.hoverStartTime = System.currentTimeMillis();
        } else if (!isHovered && wasHovered) {
            this.isMouseHovered = false;
            this.hoverStartTime = 0L;
        } else if (isHovered && (timeSinceHover = System.currentTimeMillis() - this.hoverStartTime) > 750L && this.tooltip != null) {
            List<String> hoverList = Arrays.asList(GTUtility.getForwardNewLineRegex().split(I18n.func_135052_a((String)this.tooltip, (Object[])new Object[0])));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getClickValue() {
        if (IncrementButtonWidget.isShiftDown()) {
            if (IncrementButtonWidget.isCtrlDown()) {
                return this.incrementShiftCtrl;
            }
            return this.incrementShift;
        }
        if (IncrementButtonWidget.isCtrlDown()) {
            return this.incrementCtrl;
        }
        return this.increment;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.shouldClientCallback) {
                this.updater.accept(this.clickValue);
            }
            this.writeClientAction(-1, buf -> buf.writeInt(this.clickValue));
            IncrementButtonWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.updater.accept(buffer.readInt());
        }
    }
}

