/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PhantomTankWidget
extends TankWidget
implements IGhostIngredientTarget {
    private final Supplier<FluidStack> phantomFluidGetter;
    private final Consumer<FluidStack> phantomFluidSetter;
    @Nullable
    protected FluidStack lastPhantomStack;

    public PhantomTankWidget(IFluidTank fluidTank, int x, int y, int width, int height, Supplier<FluidStack> phantomFluidGetter, Consumer<FluidStack> phantomFluidSetter) {
        super(fluidTank, x, y, width, height);
        this.phantomFluidGetter = phantomFluidGetter;
        this.phantomFluidSetter = phantomFluidSetter;
        this.setLastPhantomStack(this.phantomFluidGetter.get());
    }

    protected void setLastPhantomStack(FluidStack fluid) {
        if (fluid != null) {
            this.lastPhantomStack = fluid.copy();
            this.lastPhantomStack.amount = 1;
        } else {
            this.lastPhantomStack = null;
        }
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (this.lastFluidInTank != null || PhantomTankWidget.getFluidFromIngredient(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                FluidStack stack = PhantomTankWidget.getFluidFromIngredient(ingredient);
                if (stack != null) {
                    NBTTagCompound compound = stack.writeToNBT(new NBTTagCompound());
                    PhantomTankWidget.this.writeClientAction(13, buf -> buf.func_150786_a(compound));
                }
                PhantomTankWidget.this.phantomFluidSetter.accept(stack);
            }
        }});
    }

    @Nullable
    private static FluidStack getFluidFromIngredient(Object ingredient) {
        ItemStack itemStack;
        IFluidHandlerItem fluidHandler;
        if (ingredient instanceof FluidStack) {
            return (FluidStack)ingredient;
        }
        if (ingredient instanceof ItemStack && (fluidHandler = (IFluidHandlerItem)(itemStack = (ItemStack)ingredient).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buf) {
        if (id == 12) {
            ItemStack stack = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            if (stack.func_190926_b()) {
                this.phantomFluidSetter.accept(null);
            } else {
                stack.func_190920_e(1);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    this.phantomFluidSetter.accept(fluidHandler.drain(Integer.MAX_VALUE, false));
                }
            }
        } else if (id == 13) {
            FluidStack stack;
            try {
                stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buf.func_150793_b());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.phantomFluidSetter.accept(stack);
        } else {
            super.handleClientAction(id, buf);
        }
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidInTank == null ? this.phantomFluidGetter.get() : this.lastFluidInTank;
        }
        return null;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.writeClientAction(12, buf -> {});
            return true;
        }
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.lastFluidInTank != null) {
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
            return;
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        FluidStack fluid = this.phantomFluidGetter.get();
        if (fluid != null && !this.gui.isJEIHandled) {
            GlStateManager.func_179084_k();
            RenderUtil.drawFluidForGui(fluid, fluid.amount, pos.x + this.fluidRenderOffset, pos.y + this.fluidRenderOffset, size.width - this.fluidRenderOffset, size.height - this.fluidRenderOffset);
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.lastFluidInTank == null) {
            return;
        }
        super.drawInForeground(mouseX, mouseY);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        FluidStack stack = this.phantomFluidGetter.get();
        if (stack == null) {
            if (this.lastPhantomStack != null) {
                this.setLastPhantomStack(null);
                this.writeUpdateInfo(10, buf -> {});
            }
        } else if (this.lastPhantomStack == null || !stack.isFluidEqual(this.lastPhantomStack)) {
            this.setLastPhantomStack(stack);
            NBTTagCompound stackTag = stack.writeToNBT(new NBTTagCompound());
            this.writeUpdateInfo(11, buf -> buf.func_150786_a(stackTag));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buf) {
        if (id == 10) {
            this.phantomFluidSetter.accept(null);
        } else if (id == 11) {
            NBTTagCompound stackTag;
            try {
                stackTag = buf.func_150793_b();
            }
            catch (IOException ignored) {
                return;
            }
            this.phantomFluidSetter.accept(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag));
        } else {
            super.readUpdateInfo(id, buf);
        }
    }

    @Override
    public String getFluidLocalizedName() {
        if (this.lastFluidInTank != null) {
            return this.lastFluidInTank.getLocalizedName();
        }
        FluidStack fluid = this.phantomFluidGetter.get();
        return fluid == null ? "" : fluid.getLocalizedName();
    }
}

