/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.DoubleSupplier;
import net.minecraft.network.PacketBuffer;

public class ProgressWidget
extends Widget {
    public final DoubleSupplier progressSupplier;
    private MoveType moveType;
    private TextureArea emptyBarArea;
    private TextureArea[] filledBarArea;
    private double lastProgressValue;

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
    }

    public ProgressWidget(int ticksPerCycle, int x, int y, int width, int height) {
        this(new TimedProgressSupplier(ticksPerCycle, width, false), x, y, width, height);
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea fullImage, MoveType moveType) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
        this.emptyBarArea = fullImage.getSubArea(0.0, 0.0, 1.0, 0.5);
        this.moveType = moveType;
        this.filledBarArea = moveType == MoveType.CIRCULAR ? new TextureArea[]{fullImage.getSubArea(0.0, 0.75, 0.5, 0.25), fullImage.getSubArea(0.0, 0.5, 0.5, 0.25), fullImage.getSubArea(0.5, 0.5, 0.5, 0.25), fullImage.getSubArea(0.5, 0.75, 0.5, 0.25)} : new TextureArea[]{fullImage.getSubArea(0.0, 0.5, 1.0, 0.5)};
    }

    public ProgressWidget(int ticksPerCycle, int x, int y, int width, int height, TextureArea fullImage, MoveType moveType) {
        this(new TimedProgressSupplier(ticksPerCycle, moveType == MoveType.HORIZONTAL ? width : height, moveType == MoveType.VERTICAL_INVERTED), x, y, width, height, fullImage, moveType);
    }

    public ProgressWidget setProgressBar(TextureArea emptyBarArea, TextureArea filledBarArea, MoveType moveType) {
        this.emptyBarArea = emptyBarArea;
        this.filledBarArea = new TextureArea[]{filledBarArea};
        this.moveType = moveType;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.emptyBarArea != null) {
            this.emptyBarArea.draw(pos.x, pos.y, size.width, size.height);
        }
        if (this.filledBarArea != null) {
            if (this.moveType == MoveType.HORIZONTAL) {
                this.filledBarArea[0].drawSubArea(pos.x, pos.y, (int)((double)size.width * this.lastProgressValue), size.height, 0.0, 0.0, (double)((int)((double)size.width * this.lastProgressValue)) / ((double)size.width * 1.0), 1.0);
            } else if (this.moveType == MoveType.VERTICAL) {
                int progressValueScaled = (int)((double)size.height * this.lastProgressValue);
                this.filledBarArea[0].drawSubArea(pos.x, pos.y + size.height - progressValueScaled, size.width, progressValueScaled, 0.0, 1.0 - (double)progressValueScaled / ((double)size.height * 1.0), 1.0, (double)progressValueScaled / ((double)size.height * 1.0));
            } else if (this.moveType == MoveType.VERTICAL_INVERTED) {
                int progressValueScaled = (int)((double)size.height * this.lastProgressValue);
                this.filledBarArea[0].drawSubArea(pos.x, pos.y, size.width, progressValueScaled, 0.0, 0.0, 1.0, (double)progressValueScaled / ((double)size.height * 1.0));
            } else if (this.moveType == MoveType.CIRCULAR) {
                double[] subAreas = new double[]{Math.min(1.0, Math.max(0.0, this.lastProgressValue / 0.25)), Math.min(1.0, Math.max(0.0, (this.lastProgressValue - 0.25) / 0.25)), Math.min(1.0, Math.max(0.0, (this.lastProgressValue - 0.5) / 0.25)), Math.min(1.0, Math.max(0.0, (this.lastProgressValue - 0.75) / 0.25))};
                int halfWidth = size.width / 2;
                int halfHeight = size.height / 2;
                int progressScaled = (int)Math.round(subAreas[0] * (double)halfHeight);
                this.filledBarArea[0].drawSubArea(pos.x, pos.y + size.height - progressScaled, halfWidth, progressScaled, 0.0, 1.0 - (double)progressScaled / ((double)halfHeight * 1.0), 1.0, (double)progressScaled / ((double)halfHeight * 1.0));
                progressScaled = (int)Math.round(subAreas[1] * (double)halfWidth);
                this.filledBarArea[1].drawSubArea(pos.x, pos.y, progressScaled, halfHeight, 0.0, 0.0, (double)progressScaled / ((double)halfWidth * 1.0), 1.0);
                progressScaled = (int)Math.round(subAreas[2] * (double)halfHeight);
                this.filledBarArea[2].drawSubArea(pos.x + halfWidth, pos.y, halfWidth, progressScaled, 0.0, 0.0, 1.0, (double)progressScaled / ((double)halfHeight * 1.0));
                progressScaled = (int)Math.round(subAreas[3] * (double)halfWidth);
                this.filledBarArea[3].drawSubArea(pos.x + size.width - progressScaled, pos.y + halfHeight, progressScaled, halfHeight, 1.0 - (double)progressScaled / ((double)halfWidth * 1.0), 0.0, (double)progressScaled / ((double)halfWidth * 1.0), 1.0);
            } else if (this.moveType == MoveType.VERTICAL_DOWNWARDS) {
                this.filledBarArea[0].drawSubArea(pos.x, pos.y, size.width, (int)((double)size.height * this.lastProgressValue), 0.0, 0.0, 1.0, (double)((int)((double)size.height * this.lastProgressValue)) / ((double)size.height * 1.0));
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        double actualValue = this.progressSupplier.getAsDouble();
        if (Math.abs(actualValue - this.lastProgressValue) > 0.005) {
            this.lastProgressValue = actualValue;
            this.writeUpdateInfo(0, buffer -> buffer.writeDouble(actualValue));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastProgressValue = buffer.readDouble();
        }
    }

    public static class TimedProgressSupplier
    implements DoubleSupplier {
        private final int msPerCycle;
        private final int maxValue;
        private final boolean countDown;
        private final long startTime;

        public TimedProgressSupplier(int ticksPerCycle, int maxValue, boolean countDown) {
            this.msPerCycle = ticksPerCycle * 50;
            this.maxValue = maxValue;
            this.countDown = countDown;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public double getAsDouble() {
            return this.calculateTime();
        }

        private double calculateTime() {
            long currentTime = System.currentTimeMillis();
            long msPassed = (currentTime - this.startTime) % (long)this.msPerCycle;
            int currentValue = (int)Math.floorDiv(msPassed * (long)(this.maxValue + 1), (long)this.msPerCycle);
            if (this.countDown) {
                return (double)(this.maxValue - currentValue) / ((double)this.maxValue * 1.0);
            }
            return (double)currentValue / ((double)this.maxValue * 1.0);
        }
    }

    public static enum MoveType {
        VERTICAL,
        HORIZONTAL,
        VERTICAL_INVERTED,
        CIRCULAR,
        VERTICAL_DOWNWARDS;

    }
}

