/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.integration.jei.GTJeiPlugin;
import gregtech.integration.jei.recipe.RecipeMapCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;

public class RecipeProgressWidget
extends ProgressWidget {
    private final RecipeMap<?> recipeMap;
    private static final int HOVER_TEXT_WIDTH = 200;

    public RecipeProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, RecipeMap<?> recipeMap) {
        super(progressSupplier, x, y, width, height);
        this.recipeMap = recipeMap;
    }

    public RecipeProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea fullImage, ProgressWidget.MoveType moveType, RecipeMap<?> recipeMap) {
        super(progressSupplier, x, y, width, height, fullImage, moveType);
        this.recipeMap = recipeMap;
    }

    public RecipeProgressWidget(int ticksPerCycle, int x, int y, int width, int height, TextureArea fullImage, ProgressWidget.MoveType moveType, RecipeMap<?> recipeMap) {
        super(ticksPerCycle, x, y, width, height, fullImage, moveType);
        this.recipeMap = recipeMap;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!Loader.isModLoaded((String)"jei")) {
            return false;
        }
        if (this.isMouseOverElement(mouseX, mouseY) && RecipeMapCategory.getCategoryMap().containsKey(this.recipeMap)) {
            ArrayList<String> categoryID = new ArrayList<String>();
            if (this.recipeMap == RecipeMaps.FURNACE_RECIPES) {
                categoryID.add("minecraft.smelting");
            } else {
                categoryID.add(RecipeMapCategory.getCategoryMap().get(this.recipeMap).getUid());
            }
            if (GTJeiPlugin.jeiRuntime == null) {
                GTLog.logger.error("GTCEu JEI integration has crashed, this is not a good thing");
                return false;
            }
            GTJeiPlugin.jeiRuntime.getRecipesGui().showCategories(categoryID);
            return true;
        }
        return false;
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        if (this.isMouseOverElement(mouseX, mouseY) && Loader.isModLoaded((String)"jei")) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiUtils.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"gui.widget.recipeProgressWidget.default_tooltip", (Object[])new Object[0])), (int)mouseX, (int)mouseY, (int)this.sizes.getScreenWidth(), (int)this.sizes.getScreenHeight(), (int)200, (FontRenderer)mc.field_71466_p);
        }
    }
}

