/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextFieldWidget2
extends Widget {
    public static final Pattern NATURAL_NUMS = Pattern.compile("[0-9]*");
    public static final Pattern WHOLE_NUMS = Pattern.compile("-?[0-9]*");
    public static final Pattern DECIMALS = Pattern.compile("[0-9]*(\\.[0-9]*)?");
    public static final Pattern LETTERS = Pattern.compile("[a-zA-Z]*");
    private String text;
    private String localisedPostFix;
    private final Supplier<String> supplier;
    private final Consumer<String> setter;
    private Consumer<TextFieldWidget2> onFocus;
    private Pattern regex;
    private Function<String, String> validator = s -> s;
    private boolean initialised = false;
    private boolean centered;
    private int textColor = 0xFFFFFF;
    private int markedColor = 3109544;
    private boolean postFixRight = false;
    private int maxLength = 32;
    private float scale = 1.0f;
    private boolean focused;
    private int cursorPos;
    private int cursorPos2;
    private int clickTime = 20;
    private int cursorTime = 0;
    private boolean drawCursor = true;
    @Nullable
    private Boolean unicodeMode;

    public TextFieldWidget2(int x, int y, int width, int height, Supplier<String> supplier, Consumer<String> setter) {
        super(x, y, width, height);
        this.supplier = supplier;
        this.setter = setter;
        this.setText(supplier.get());
    }

    @Override
    public void initWidget() {
        if (this.isRemote()) {
            this.localisedPostFix = I18n.func_188566_a((String)this.localisedPostFix) ? I18n.func_135052_a((String)this.localisedPostFix, (Object[])new Object[0]) : this.localisedPostFix;
        }
    }

    @Override
    public void updateScreen() {
        ++this.clickTime;
        if (++this.cursorTime == 10) {
            this.cursorTime = 0;
            this.drawCursor = !this.drawCursor;
        }
    }

    @Override
    public void detectAndSendChanges() {
        String t = this.supplier.get();
        if (!this.initialised || !this.focused && !this.getText().equals(t)) {
            this.setText(t);
            this.writeUpdateInfo(-2, buf -> buf.func_180714_a(t));
            this.initialised = true;
        }
    }

    protected int getTextX() {
        if (this.centered) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            boolean prevUnicode = fontRenderer.func_82883_a();
            if (this.unicodeMode != null) {
                fontRenderer.func_78264_a(this.unicodeMode.booleanValue());
            }
            float textW = (float)fontRenderer.func_78256_a(this.getRenderText()) * this.scale;
            if (this.localisedPostFix != null && !this.localisedPostFix.isEmpty()) {
                textW += 3.0f + (float)fontRenderer.func_78256_a(this.localisedPostFix) * this.scale;
            }
            int x = (int)((float)this.getSize().width / 2.0f - textW / 2.0f + (float)this.getPosition().x);
            if (this.unicodeMode != null) {
                fontRenderer.func_78264_a(prevUnicode);
            }
            return x;
        }
        return this.getPosition().x + 1;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int y = this.getPosition().y;
        int textX = this.getTextX();
        boolean prevUnicode = fontRenderer.func_82883_a();
        if (this.unicodeMode != null) {
            fontRenderer.func_78264_a(this.unicodeMode.booleanValue());
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
        float scaleFactor = 1.0f / this.scale;
        y = (int)((float)y * scaleFactor);
        String text = this.getRenderText();
        if (this.cursorPos != this.cursorPos2) {
            float startX = (float)fontRenderer.func_78256_a(text.substring(0, this.toRenderTextIndex(Math.min(this.cursorPos, this.cursorPos2)))) * this.scale + (float)textX;
            String marked = this.getSelectedText();
            float width = fontRenderer.func_78256_a(marked);
            this.drawSelectionBox(startX * scaleFactor, y, width);
        }
        fontRenderer.func_78276_b(text, (int)((float)textX * scaleFactor), y, this.textColor);
        if (this.localisedPostFix != null && !this.localisedPostFix.isEmpty()) {
            int x = this.postFixRight && !this.centered ? this.getPosition().x + this.getSize().width - (fontRenderer.func_78256_a(this.localisedPostFix) + 1) : textX + fontRenderer.func_78256_a(text) + 3;
            x = (int)((float)x * scaleFactor);
            fontRenderer.func_78276_b(this.localisedPostFix, x, y, this.textColor);
        }
        if (this.focused && this.drawCursor) {
            String sub = text.substring(0, this.toRenderTextIndex(this.cursorPos));
            float x = (float)fontRenderer.func_78256_a(sub) * this.scale + (float)textX;
            this.drawCursor(x *= scaleFactor, y);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        if (this.unicodeMode != null) {
            fontRenderer.func_78264_a(prevUnicode);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawCursor(float x, float y) {
        float endX = (x -= 0.9f) + 0.5f * (1.0f / this.scale);
        float endY = (y -= 1.0f) + 9.0f;
        float red = (float)(this.textColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.textColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.textColor & 0xFF) / 255.0f;
        float alpha = (float)(this.textColor >> 24 & 0xFF) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GlStateManager.func_179090_x();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)x, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)y, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSelectionBox(float x, float y, float width) {
        float endX = x + width;
        float endY = (y -= 1.0f) + (float)Minecraft.func_71410_x().field_71466_p.field_78288_b;
        float red = (float)(this.markedColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.markedColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.markedColor & 0xFF) / 255.0f;
        float alpha = (float)(this.markedColor >> 24 & 0xFF) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GlStateManager.func_179090_x();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)x, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)y, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.focused = true;
            if (this.onFocus != null) {
                this.onFocus.accept(this);
            }
            if (this.clickTime < 5) {
                this.cursorPos = this.getText().length();
                this.cursorPos2 = 0;
            } else {
                this.cursorPos2 = this.cursorPos = this.getCursorPosFromMouse(mouseX);
            }
            this.clickTime = 0;
        } else {
            this.unFocus();
        }
        return this.focused;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.focused && button == 0) {
            if (mouseX < this.getPosition().x) {
                this.cursorPos = 0;
                return true;
            }
            this.cursorPos = this.getCursorPosFromMouse(mouseX);
        }
        return this.focused;
    }

    private int getCursorPosFromMouse(int mouseX) {
        int cw;
        int base = mouseX - this.getTextX();
        int i = 0;
        String renderText = this.getRenderText();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean bold = false;
        for (float x = 0.0f; i < renderText.length() && x < (float)base; x += (float)(bold && cw > 0 ? cw + 1 : cw) * this.scale, ++i) {
            char c2;
            char c = renderText.charAt(i);
            cw = fontRenderer.func_78263_a(c);
            if (cw >= 0 || i >= renderText.length() - 1) continue;
            cw = 0;
            if ((c2 = renderText.charAt(++i)) != 'l' && c2 != 'L') {
                if (c2 != 'r' && c2 != 'R') continue;
                bold = false;
                continue;
            }
            bold = true;
        }
        return this.toOriginalTextIndex(i);
    }

    public String getSelectedText() {
        return this.getText().substring(Math.min(this.cursorPos, this.cursorPos2), Math.max(this.cursorPos, this.cursorPos2));
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        if (this.focused) {
            if (keyCode == 1) {
                this.unFocus();
                return false;
            }
            if (keyCode == 28) {
                this.unFocus();
                return true;
            }
            if (GuiScreen.func_175278_g((int)keyCode)) {
                this.cursorPos = this.getText().length();
                this.cursorPos2 = 0;
                return true;
            }
            if (GuiScreen.func_175280_f((int)keyCode)) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            if (GuiScreen.func_175279_e((int)keyCode)) {
                String clip = GuiScreen.func_146277_j();
                if (this.getText().length() + clip.length() > this.maxLength || !this.isAllowed(clip)) {
                    return true;
                }
                this.replaceMarkedText(clip);
                return true;
            }
            if (GuiScreen.func_175277_d((int)keyCode)) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                this.replaceMarkedText(null);
                return true;
            }
            if (keyCode == 203) {
                if (this.cursorPos > 0) {
                    int amount = 1;
                    int pos = this.cursorPos;
                    if (TextFieldWidget2.isCtrlDown()) {
                        for (int i = pos - 1; i >= 0; --i) {
                            if (i != 0 && this.getText().charAt(i) != ' ') continue;
                            amount = pos - i;
                            break;
                        }
                    }
                    this.cursorPos -= amount;
                    if (this.cursorPos < 0) {
                        this.cursorPos = 0;
                    }
                    if (!TextFieldWidget2.isShiftDown()) {
                        this.cursorPos2 = this.cursorPos;
                    }
                }
                return true;
            }
            if (keyCode == 205) {
                if (this.cursorPos < this.getText().length()) {
                    int amount = 1;
                    int pos = this.cursorPos;
                    if (TextFieldWidget2.isCtrlDown()) {
                        for (int i = pos + 1; i < this.getText().length(); ++i) {
                            if (i != this.getText().length() - 1 && this.getText().charAt(i) != ' ') continue;
                            amount = i - pos;
                            break;
                        }
                    }
                    this.cursorPos = Math.min(this.cursorPos + amount, this.getText().length());
                    if (!TextFieldWidget2.isShiftDown()) {
                        this.cursorPos2 = this.cursorPos;
                    }
                }
                return true;
            }
            if (keyCode == 14) {
                if (this.getText().length() > 0) {
                    if (this.cursorPos != this.cursorPos2) {
                        this.replaceMarkedText(null);
                    } else if (this.cursorPos > 0) {
                        this.setText(this.getText().substring(0, this.cursorPos - 1) + this.getText().substring(this.cursorPos));
                        --this.cursorPos;
                        this.cursorPos2 = this.cursorPos;
                    }
                }
                return true;
            }
            if (keyCode == 211) {
                if (this.getText().length() > 0) {
                    if (this.cursorPos != this.cursorPos2) {
                        this.replaceMarkedText(null);
                    } else if (this.cursorPos < this.getText().length()) {
                        this.setText(this.getText().substring(0, this.cursorPos) + this.getText().substring(this.cursorPos + 1));
                    }
                }
                return true;
            }
            if (charTyped != '\u0000' && this.getText().length() < this.maxLength) {
                int min = Math.min(this.cursorPos, this.cursorPos2);
                int max = Math.max(this.cursorPos, this.cursorPos2);
                String newText = this.getText().substring(0, min) + charTyped + this.getText().substring(max);
                if (this.isAllowed(newText)) {
                    this.setText(newText);
                    this.cursorPos2 = this.cursorPos = min + 1;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isAllowed(String t) {
        return this.regex == null || this.regex.matcher(t).matches();
    }

    private void replaceMarkedText(String replacement) {
        int min = Math.min(this.cursorPos, this.cursorPos2);
        int max = Math.max(this.cursorPos, this.cursorPos2);
        String t1 = this.getText().substring(0, min);
        String t2 = this.getText().substring(max);
        if (replacement != null && t1.length() + t2.length() + replacement.length() > this.maxLength) {
            return;
        }
        if (replacement == null) {
            this.setText(t1 + t2);
            this.cursorPos = min;
        } else {
            this.setText(t1 + replacement + t2);
            this.cursorPos = t1.length() + replacement.length();
        }
        this.cursorPos2 = this.cursorPos;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected String getRenderText() {
        return this.getText();
    }

    protected int toOriginalTextIndex(int renderTextIndex) {
        return renderTextIndex;
    }

    protected int toRenderTextIndex(int originalTextIndex) {
        return originalTextIndex;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void unFocus() {
        if (!this.focused) {
            return;
        }
        this.cursorPos2 = this.cursorPos;
        String t = this.validator.apply(this.getText());
        this.setText(t);
        this.setter.accept(t);
        this.focused = false;
        this.writeClientAction(-1, buf -> buf.func_180714_a(t));
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.setText(buffer.func_150789_c(this.maxLength));
            this.setter.accept(this.getText());
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -2) {
            this.setText(buffer.func_150789_c(this.maxLength));
            this.setter.accept(this.getText());
            this.initialised = true;
            if (this.cursorPos > this.getText().length()) {
                this.cursorPos = this.getText().length();
            }
            if (this.cursorPos2 > this.getText().length()) {
                this.cursorPos2 = this.getText().length();
            }
        }
    }

    public TextFieldWidget2 setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public TextFieldWidget2 setAllowedChars(Pattern regex) {
        this.regex = regex;
        return this;
    }

    public TextFieldWidget2 setValidator(Function<String, String> validator) {
        this.validator = validator;
        return this;
    }

    public TextFieldWidget2 setNumbersOnly(int min, int max) {
        if (this.regex == null) {
            this.regex = min < 0 ? WHOLE_NUMS : NATURAL_NUMS;
        }
        this.setValidator(val -> {
            int num;
            if (val.isEmpty()) {
                return String.valueOf(min);
            }
            for (int i = 0; i < val.length(); ++i) {
                char c = val.charAt(i);
                if (c != '-' || min < 0 && i == 0) continue;
                return String.valueOf(min);
            }
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException ignored) {
                return String.valueOf(max);
            }
            if (num < min) {
                return String.valueOf(min);
            }
            if (num > max) {
                return String.valueOf(max);
            }
            return val;
        });
        return this;
    }

    public TextFieldWidget2 setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public TextFieldWidget2 setPostFix(String postFix) {
        this.localisedPostFix = postFix;
        if (this.gui != null && this.gui.holder != null && this.isRemote()) {
            this.localisedPostFix = I18n.func_188566_a((String)this.localisedPostFix) ? I18n.func_135052_a((String)this.localisedPostFix, (Object[])new Object[0]) : this.localisedPostFix;
        }
        return this;
    }

    public TextFieldWidget2 setMarkedColor(int markedColor) {
        this.markedColor = markedColor;
        return this;
    }

    public TextFieldWidget2 bindPostFixToRight(boolean postFixRight) {
        this.postFixRight = postFixRight;
        return this;
    }

    public TextFieldWidget2 setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public TextFieldWidget2 setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public TextFieldWidget2 setOnFocus(Consumer<TextFieldWidget2> onFocus) {
        this.onFocus = onFocus;
        return this;
    }

    public TextFieldWidget2 setUnicodeMode(@Nullable Boolean unicodeMode) {
        this.unicodeMode = unicodeMode;
        return this;
    }
}

