/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.tab;

import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.tab.ITabInfo;
import gregtech.api.gui.widgets.tab.TabListRenderer;
import gregtech.api.util.Position;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class VerticalTabListRenderer
extends TabListRenderer {
    private final VerticalStartCorner startCorner;
    private final HorizontalLocation verticalLocation;

    public VerticalTabListRenderer(VerticalStartCorner startCorner, HorizontalLocation verticalLocation) {
        this.startCorner = startCorner;
        this.verticalLocation = verticalLocation;
    }

    @Override
    public void renderTabs(ModularUI gui, Position offset, List<ITabInfo> tabInfos, int guiWidth, int guiHeight, int selectedTabIndex) {
        boolean startTop = this.startCorner == VerticalStartCorner.TOP;
        boolean isLeftLine = this.verticalLocation == HorizontalLocation.LEFT;
        int tabXPosition = isLeftLine ? -28 : guiWidth - 4;
        int currentYPosition = 0;
        GlStateManager.func_179131_c((float)gui.getRColorForOverlay(), (float)gui.getGColorForOverlay(), (float)gui.getBColorForOverlay(), (float)1.0f);
        for (int tabIndex = 0; tabIndex < tabInfos.size(); ++tabIndex) {
            boolean isTabSelected = tabIndex == selectedTabIndex;
            boolean isTabFirst = tabIndex == 0;
            TextureArea tabTexture = VerticalTabListRenderer.getTabTexture(isTabSelected, isTabFirst, isLeftLine, startTop);
            int finalPosY = startTop ? currentYPosition : guiHeight - 28 - currentYPosition;
            tabInfos.get(tabIndex).renderTab(tabTexture, offset.x + tabXPosition, offset.y + finalPosY, 32, 28, isTabSelected);
            currentYPosition += 28;
            GlStateManager.func_179131_c((float)gui.getRColorForOverlay(), (float)gui.getGColorForOverlay(), (float)gui.getBColorForOverlay(), (float)1.0f);
        }
    }

    private static TextureArea getTabTexture(boolean isTabSelected, boolean isTabFirst, boolean isLeftSide, boolean startTop) {
        if (isLeftSide) {
            return LeftTextures.getTabTexture(isTabFirst, startTop, isTabSelected);
        }
        return RightTextures.getTabTexture(isTabFirst, startTop, isTabSelected);
    }

    @Override
    public int[] getTabPos(int tabIndex, int guiWidth, int guiHeight) {
        boolean startTop = this.startCorner == VerticalStartCorner.TOP;
        boolean isLeftLine = this.verticalLocation == HorizontalLocation.LEFT;
        int tabXPosition = isLeftLine ? -28 : guiWidth - 4;
        int tabYOffset = 28 * tabIndex;
        return new int[]{tabXPosition, startTop ? tabYOffset : guiHeight - 28 - tabYOffset, 32, 28};
    }

    private static final class RightTextures {
        private static final TextureArea startTabInactiveTexture = TabListRenderer.TABS_RIGHT_TEXTURE.getSubArea(0.5, 0.0, 0.5, 0.3333333333333333);
        private static final TextureArea startTabActiveTexture = TabListRenderer.TABS_RIGHT_TEXTURE.getSubArea(0.0, 0.0, 0.5, 0.3333333333333333);
        private static final TextureArea middleTabInactiveTexture = TabListRenderer.TABS_RIGHT_TEXTURE.getSubArea(0.5, 0.3333333333333333, 0.5, 0.3333333333333333);
        private static final TextureArea middleTabActiveTexture = TabListRenderer.TABS_RIGHT_TEXTURE.getSubArea(0.0, 0.3333333333333333, 0.5, 0.3333333333333333);
        private static final TextureArea endTabInactiveTexture = TabListRenderer.TABS_RIGHT_TEXTURE.getSubArea(0.5, 0.6666666666666666, 0.5, 0.3333333333333333);
        private static final TextureArea endTabActiveTexture = TabListRenderer.TABS_RIGHT_TEXTURE.getSubArea(0.0, 0.6666666666666666, 0.5, 0.3333333333333333);

        private RightTextures() {
        }

        private static TextureArea getTabTexture(boolean isTabFirst, boolean startTop, boolean isTabSelected) {
            return isTabFirst ? (startTop ? (isTabSelected ? startTabActiveTexture : startTabInactiveTexture) : (isTabSelected ? endTabActiveTexture : endTabInactiveTexture)) : (isTabSelected ? middleTabActiveTexture : middleTabInactiveTexture);
        }
    }

    private static final class LeftTextures {
        private static final TextureArea startTabInactiveTexture = TabListRenderer.TABS_LEFT_TEXTURE.getSubArea(0.0, 0.0, 0.5, 0.3333333333333333);
        private static final TextureArea startTabActiveTexture = TabListRenderer.TABS_LEFT_TEXTURE.getSubArea(0.5, 0.0, 0.5, 0.3333333333333333);
        private static final TextureArea middleTabInactiveTexture = TabListRenderer.TABS_LEFT_TEXTURE.getSubArea(0.0, 0.3333333333333333, 0.5, 0.3333333333333333);
        private static final TextureArea middleTabActiveTexture = TabListRenderer.TABS_LEFT_TEXTURE.getSubArea(0.5, 0.3333333333333333, 0.5, 0.3333333333333333);
        private static final TextureArea endTabInactiveTexture = TabListRenderer.TABS_LEFT_TEXTURE.getSubArea(0.0, 0.6666666666666666, 0.5, 0.3333333333333333);
        private static final TextureArea endTabActiveTexture = TabListRenderer.TABS_LEFT_TEXTURE.getSubArea(0.5, 0.6666666666666666, 0.5, 0.3333333333333333);

        private LeftTextures() {
        }

        private static TextureArea getTabTexture(boolean isTabFirst, boolean startTop, boolean isTabSelected) {
            return isTabFirst ? (startTop ? (isTabSelected ? startTabActiveTexture : startTabInactiveTexture) : (isTabSelected ? endTabActiveTexture : endTabInactiveTexture)) : (isTabSelected ? middleTabActiveTexture : middleTabInactiveTexture);
        }
    }

    public static enum HorizontalLocation {
        LEFT,
        RIGHT;

    }

    public static enum VerticalStartCorner {
        TOP,
        BOTTOM;

    }
}

