/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.IGTToolDefinition;
import gregtech.api.items.toolitem.ToolDefinitionBuilder;
import gregtech.api.items.toolitem.ToolHelper;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;

public abstract class ToolBuilder<T extends IGTTool> {
    protected final String domain;
    protected final String id;
    protected final Set<String> toolClasses = new ObjectArraySet();
    protected String oreDict;
    protected List<String> secondaryOreDicts = new ArrayList<String>();
    protected int tier = -1;
    protected IGTToolDefinition toolStats;
    protected SoundEvent sound;
    protected boolean playSoundOnBlockDestroy;
    protected Character symbol = null;
    protected Supplier<ItemStack> markerItem;

    public ToolBuilder(String domain, String id) {
        this.domain = domain;
        this.id = id;
    }

    public ToolBuilder<T> electric(int tier) {
        this.tier = tier;
        return this;
    }

    public ToolBuilder<T> toolStats(IGTToolDefinition toolStats) {
        this.toolStats = toolStats;
        return this;
    }

    public ToolBuilder<T> toolStats(UnaryOperator<ToolDefinitionBuilder> builder) {
        this.toolStats = ((ToolDefinitionBuilder)builder.apply(new ToolDefinitionBuilder())).build();
        return this;
    }

    public ToolBuilder<T> sound(SoundEvent sound) {
        return this.sound(sound, false);
    }

    public ToolBuilder<T> sound(SoundEvent sound, boolean playSoundOnBlockDestroy) {
        this.sound = sound;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        return this;
    }

    public ToolBuilder<T> toolClasses(String ... tools) {
        Collections.addAll(this.toolClasses, tools);
        return this;
    }

    public ToolBuilder<T> toolClasses(Set<String> tools) {
        this.toolClasses.addAll(tools);
        return this;
    }

    public ToolBuilder<T> oreDict(@Nonnull String oreDict) {
        this.oreDict = oreDict;
        return this;
    }

    public ToolBuilder<T> oreDict(@Nonnull Enum<?> oreDict) {
        this.oreDict = oreDict.name();
        return this;
    }

    public ToolBuilder<T> secondaryOreDicts(Enum<?> ... oreDicts) {
        Arrays.stream(oreDicts).map(Enum::name).forEach(this.secondaryOreDicts::add);
        return this;
    }

    public ToolBuilder<T> secondaryOreDicts(String ... oreDicts) {
        this.secondaryOreDicts.addAll(Arrays.asList(oreDicts));
        return this;
    }

    public ToolBuilder<T> symbol(char symbol) {
        this.symbol = Character.valueOf(symbol);
        return this;
    }

    public ToolBuilder<T> markerItem(Supplier<ItemStack> markerItem) {
        this.markerItem = markerItem;
        return this;
    }

    public abstract Supplier<T> supply();

    public T build() {
        if (this.symbol == null) {
            return (T)((IGTTool)this.supply().get());
        }
        IGTTool existing = ToolHelper.getToolFromSymbol(this.symbol);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Symbol %s has been taken by %s already!", this.symbol, existing));
        }
        IGTTool supplied = (IGTTool)this.supply().get();
        ToolHelper.registerToolSymbol(this.symbol, supplied);
        return (T)supplied;
    }
}

